"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var consts_exports = {};
__export(consts_exports, {
  FLASH_MAX_PAGE_SIZE_700: () => FLASH_MAX_PAGE_SIZE_700,
  FLASH_MAX_PAGE_SIZE_800: () => FLASH_MAX_PAGE_SIZE_800,
  FragmentType: () => FragmentType,
  NVM3_CODE_LARGE_SHIFT: () => NVM3_CODE_LARGE_SHIFT,
  NVM3_CODE_SMALL_SHIFT: () => NVM3_CODE_SMALL_SHIFT,
  NVM3_COUNTER_SIZE: () => NVM3_COUNTER_SIZE,
  NVM3_MAX_OBJ_SIZE_LARGE: () => NVM3_MAX_OBJ_SIZE_LARGE,
  NVM3_MAX_OBJ_SIZE_SMALL: () => NVM3_MAX_OBJ_SIZE_SMALL,
  NVM3_MIN_PAGE_SIZE: () => NVM3_MIN_PAGE_SIZE,
  NVM3_OBJ_FRAGTYPE_MASK: () => NVM3_OBJ_FRAGTYPE_MASK,
  NVM3_OBJ_FRAGTYPE_SHIFT: () => NVM3_OBJ_FRAGTYPE_SHIFT,
  NVM3_OBJ_HEADER_SIZE_LARGE: () => NVM3_OBJ_HEADER_SIZE_LARGE,
  NVM3_OBJ_HEADER_SIZE_SMALL: () => NVM3_OBJ_HEADER_SIZE_SMALL,
  NVM3_OBJ_KEY_MASK: () => NVM3_OBJ_KEY_MASK,
  NVM3_OBJ_KEY_SHIFT: () => NVM3_OBJ_KEY_SHIFT,
  NVM3_OBJ_KEY_SIZE: () => NVM3_OBJ_KEY_SIZE,
  NVM3_OBJ_LARGE_LEN_MASK: () => NVM3_OBJ_LARGE_LEN_MASK,
  NVM3_OBJ_LARGE_LEN_SIZE: () => NVM3_OBJ_LARGE_LEN_SIZE,
  NVM3_OBJ_TYPE_MASK: () => NVM3_OBJ_TYPE_MASK,
  NVM3_PAGE_COUNTER_MASK: () => NVM3_PAGE_COUNTER_MASK,
  NVM3_PAGE_COUNTER_SIZE: () => NVM3_PAGE_COUNTER_SIZE,
  NVM3_PAGE_HEADER_SIZE: () => NVM3_PAGE_HEADER_SIZE,
  NVM3_PAGE_MAGIC: () => NVM3_PAGE_MAGIC,
  NVM3_WORD_SIZE: () => NVM3_WORD_SIZE,
  ObjectType: () => ObjectType,
  PageStatus: () => PageStatus,
  PageWriteSize: () => PageWriteSize,
  ZWAVE_APPLICATION_NVM_SIZE: () => ZWAVE_APPLICATION_NVM_SIZE,
  ZWAVE_PROTOCOL_NVM_SIZE: () => ZWAVE_PROTOCOL_NVM_SIZE,
  ZWAVE_SHARED_NVM_SIZE: () => ZWAVE_SHARED_NVM_SIZE
});
module.exports = __toCommonJS(consts_exports);
const ZWAVE_APPLICATION_NVM_SIZE = 12288;
const ZWAVE_PROTOCOL_NVM_SIZE = 49152 - ZWAVE_APPLICATION_NVM_SIZE;
const ZWAVE_SHARED_NVM_SIZE = 40960;
const NVM3_WORD_SIZE = 4;
const NVM3_MIN_PAGE_SIZE = 512;
const NVM3_PAGE_HEADER_SIZE = 20;
const NVM3_PAGE_COUNTER_SIZE = 27;
const NVM3_PAGE_COUNTER_MASK = (1 << NVM3_PAGE_COUNTER_SIZE) - 1;
const NVM3_PAGE_MAGIC = 45722;
const FLASH_MAX_PAGE_SIZE_700 = 2048;
const FLASH_MAX_PAGE_SIZE_800 = 8192;
var PageStatus;
(function(PageStatus2) {
  PageStatus2[PageStatus2["OK"] = 4294967295] = "OK";
  PageStatus2[PageStatus2["OK_ErasePending"] = 4294944165] = "OK_ErasePending";
  PageStatus2[PageStatus2["Bad"] = 65535] = "Bad";
  PageStatus2[PageStatus2["Bad_ErasePending"] = 42405] = "Bad_ErasePending";
})(PageStatus || (PageStatus = {}));
var PageWriteSize;
(function(PageWriteSize2) {
  PageWriteSize2[PageWriteSize2["WRITE_SIZE_32"] = 0] = "WRITE_SIZE_32";
  PageWriteSize2[PageWriteSize2["WRITE_SIZE_16"] = 1] = "WRITE_SIZE_16";
})(PageWriteSize || (PageWriteSize = {}));
const NVM3_OBJ_KEY_SHIFT = 7;
const NVM3_OBJ_KEY_SIZE = 20;
const NVM3_OBJ_KEY_MASK = (1 << NVM3_OBJ_KEY_SIZE) - 1;
const NVM3_OBJ_TYPE_MASK = 127;
const NVM3_OBJ_LARGE_LEN_SIZE = 26;
const NVM3_OBJ_LARGE_LEN_MASK = (1 << NVM3_OBJ_LARGE_LEN_SIZE) - 1;
const NVM3_OBJ_FRAGTYPE_SHIFT = 27;
const NVM3_OBJ_FRAGTYPE_MASK = 3;
const NVM3_CODE_SMALL_SHIFT = 27;
const NVM3_CODE_LARGE_SHIFT = 26;
const NVM3_OBJ_HEADER_SIZE_SMALL = 4;
const NVM3_OBJ_HEADER_SIZE_LARGE = 8;
const NVM3_MAX_OBJ_SIZE_SMALL = 120;
const NVM3_MAX_OBJ_SIZE_LARGE = 1900;
const NVM3_COUNTER_SIZE = 204;
var ObjectType;
(function(ObjectType2) {
  ObjectType2[ObjectType2["DataLarge"] = 0] = "DataLarge";
  ObjectType2[ObjectType2["CounterLarge"] = 1] = "CounterLarge";
  ObjectType2[ObjectType2["CounterSmall"] = 2] = "CounterSmall";
  ObjectType2[ObjectType2["Deleted"] = 3] = "Deleted";
  ObjectType2[ObjectType2["DataSmall"] = 7] = "DataSmall";
})(ObjectType || (ObjectType = {}));
var FragmentType;
(function(FragmentType2) {
  FragmentType2[FragmentType2["None"] = 0] = "None";
  FragmentType2[FragmentType2["First"] = 1] = "First";
  FragmentType2[FragmentType2["Next"] = 2] = "Next";
  FragmentType2[FragmentType2["Last"] = 3] = "Last";
})(FragmentType || (FragmentType = {}));
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  FLASH_MAX_PAGE_SIZE_700,
  FLASH_MAX_PAGE_SIZE_800,
  FragmentType,
  NVM3_CODE_LARGE_SHIFT,
  NVM3_CODE_SMALL_SHIFT,
  NVM3_COUNTER_SIZE,
  NVM3_MAX_OBJ_SIZE_LARGE,
  NVM3_MAX_OBJ_SIZE_SMALL,
  NVM3_MIN_PAGE_SIZE,
  NVM3_OBJ_FRAGTYPE_MASK,
  NVM3_OBJ_FRAGTYPE_SHIFT,
  NVM3_OBJ_HEADER_SIZE_LARGE,
  NVM3_OBJ_HEADER_SIZE_SMALL,
  NVM3_OBJ_KEY_MASK,
  NVM3_OBJ_KEY_SHIFT,
  NVM3_OBJ_KEY_SIZE,
  NVM3_OBJ_LARGE_LEN_MASK,
  NVM3_OBJ_LARGE_LEN_SIZE,
  NVM3_OBJ_TYPE_MASK,
  NVM3_PAGE_COUNTER_MASK,
  NVM3_PAGE_COUNTER_SIZE,
  NVM3_PAGE_HEADER_SIZE,
  NVM3_PAGE_MAGIC,
  NVM3_WORD_SIZE,
  ObjectType,
  PageStatus,
  PageWriteSize,
  ZWAVE_APPLICATION_NVM_SIZE,
  ZWAVE_PROTOCOL_NVM_SIZE,
  ZWAVE_SHARED_NVM_SIZE
});
//# sourceMappingURL=consts.js.map
