"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ApplicationCCsFile_exports = {};
__export(ApplicationCCsFile_exports, {
  ApplicationCCsFile: () => ApplicationCCsFile,
  ApplicationCCsFileID: () => ApplicationCCsFileID
});
module.exports = __toCommonJS(ApplicationCCsFile_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_NVMFile = require("./NVMFile.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
const MAX_CCs = 35;
const ApplicationCCsFileID = 103;
let ApplicationCCsFile = (() => {
  let _classDecorators = [(0, import_NVMFile.nvmFileID)(ApplicationCCsFileID), (0, import_NVMFile.nvmSection)("application")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_NVMFile.NVMFile;
  var ApplicationCCsFile2 = class extends _classSuper {
    static {
      __name(this, "ApplicationCCsFile");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationCCsFile2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ((0, import_NVMFile.gotDeserializationOptions)(options)) {
        let offset = 0;
        let numCCs = this.payload[offset];
        this.includedInsecurely = [
          ...this.payload.subarray(offset + 1, offset + 1 + numCCs)
        ];
        offset += 1 + MAX_CCs;
        numCCs = this.payload[offset];
        this.includedSecurelyInsecureCCs = [
          ...this.payload.subarray(offset + 1, offset + 1 + numCCs)
        ];
        offset += 1 + MAX_CCs;
        numCCs = this.payload[offset];
        this.includedSecurelySecureCCs = [
          ...this.payload.subarray(offset + 1, offset + 1 + numCCs)
        ];
      } else {
        this.includedInsecurely = options.includedInsecurely;
        this.includedSecurelyInsecureCCs = options.includedSecurelyInsecureCCs;
        this.includedSecurelySecureCCs = options.includedSecurelySecureCCs;
      }
    }
    includedInsecurely;
    includedSecurelyInsecureCCs;
    includedSecurelySecureCCs;
    serialize() {
      this.payload = new import_shared.Bytes((1 + MAX_CCs) * 3);
      let offset = 0;
      for (const array of [
        this.includedInsecurely,
        this.includedSecurelyInsecureCCs,
        this.includedSecurelySecureCCs
      ]) {
        this.payload[offset] = array.length;
        this.payload.set(array, offset + 1);
        offset += 1 + MAX_CCs;
      }
      return super.serialize();
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    toJSON() {
      return {
        ...super.toJSON(),
        "included insecurely": this.includedInsecurely.map((cc) => import_core.CommandClasses[cc]).join(", "),
        "included securely (insecure)": this.includedSecurelyInsecureCCs.map((cc) => import_core.CommandClasses[cc]).join(", "),
        "included securely (secure)": this.includedSecurelySecureCCs.map((cc) => import_core.CommandClasses[cc]).join(", ")
      };
    }
  };
  return ApplicationCCsFile2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ApplicationCCsFile,
  ApplicationCCsFileID
});
//# sourceMappingURL=ApplicationCCsFile.js.map
