"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ApplicationRFConfigFile_exports = {};
__export(ApplicationRFConfigFile_exports, {
  ApplicationRFConfigFile: () => ApplicationRFConfigFile,
  ApplicationRFConfigFileID: () => ApplicationRFConfigFileID
});
module.exports = __toCommonJS(ApplicationRFConfigFile_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_gte = __toESM(require("semver/functions/gte.js"), 1);
var import_lt = __toESM(require("semver/functions/lt.js"), 1);
var import_NVMFile = require("./NVMFile.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
const ApplicationRFConfigFileID = 104;
let ApplicationRFConfigFile = (() => {
  let _classDecorators = [(0, import_NVMFile.nvmFileID)(ApplicationRFConfigFileID), (0, import_NVMFile.nvmSection)("application")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_NVMFile.NVMFile;
  var ApplicationRFConfigFile2 = class extends _classSuper {
    static {
      __name(this, "ApplicationRFConfigFile");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationRFConfigFile2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ((0, import_NVMFile.gotDeserializationOptions)(options)) {
        if (this.payload.length === 3 || this.payload.length === 6) {
          this.rfRegion = this.payload[0];
          this.txPower = this.payload.readInt8(1) / 10;
          this.measured0dBm = this.payload.readInt8(2) / 10;
          if (this.payload.length === 6) {
            this.enablePTI = this.payload[3];
            this.maxTXPower = this.payload.readInt16LE(4) / 10;
          }
        } else if (this.payload.length === 8) {
          this.rfRegion = this.payload[0];
          this.txPower = this.payload.readInt16LE(1) / 10;
          this.measured0dBm = this.payload.readInt16LE(3) / 10;
          this.enablePTI = this.payload[5];
          this.maxTXPower = this.payload.readInt16LE(6) / 10;
        } else if (this.payload.length === 9) {
          this.rfRegion = this.payload[0];
          this.txPower = this.payload.readInt16LE(1) / 10;
          this.measured0dBm = this.payload.readInt16LE(3) / 10;
          this.enablePTI = this.payload[5];
          this.maxTXPower = this.payload.readInt16LE(6) / 10;
          this.nodeIdType = this.payload[8];
        } else {
          throw new import_core.ZWaveError(`ApplicationRFConfigFile has unsupported length ${this.payload.length}`, import_core.ZWaveErrorCodes.NVM_NotSupported);
        }
      } else {
        this.rfRegion = options.rfRegion;
        this.txPower = options.txPower;
        this.measured0dBm = options.measured0dBm;
        this.enablePTI = options.enablePTI;
        this.maxTXPower = options.maxTXPower;
        this.nodeIdType = options.nodeIdType;
      }
    }
    rfRegion;
    txPower;
    measured0dBm;
    enablePTI;
    maxTXPower;
    nodeIdType;
    serialize() {
      if ((0, import_lt.default)(this.fileVersion, "7.18.1")) {
        this.payload = new import_shared.Bytes((0, import_gte.default)(this.fileVersion, "7.15.3") ? 6 : 3).fill(0);
        this.payload[0] = this.rfRegion;
        this.payload.writeIntLE(this.txPower * 10, 1, 1);
        this.payload.writeIntLE(this.measured0dBm * 10, 2, 1);
        if ((0, import_gte.default)(this.fileVersion, "7.15.3")) {
          this.payload[3] = this.enablePTI ?? 0;
          this.payload.writeInt16LE((this.maxTXPower ?? 0) * 10, 4);
        }
      } else if ((0, import_lt.default)(this.fileVersion, "7.21.0")) {
        this.payload = new import_shared.Bytes(8).fill(0);
        this.payload[0] = this.rfRegion;
        this.payload.writeInt16LE(this.txPower * 10, 1);
        this.payload.writeInt16LE(this.measured0dBm * 10, 3);
        this.payload[5] = this.enablePTI ?? 0;
        this.payload.writeInt16LE((this.maxTXPower ?? 0) * 10, 6);
      } else {
        this.payload = new import_shared.Bytes(9).fill(0);
        this.payload[0] = this.rfRegion;
        this.payload.writeInt16LE(this.txPower * 10, 1);
        this.payload.writeInt16LE(this.measured0dBm * 10, 3);
        this.payload[5] = this.enablePTI ?? 0;
        this.payload.writeInt16LE((this.maxTXPower ?? 0) * 10, 6);
        this.payload[8] = this.nodeIdType ?? import_core.NodeIDType.Short;
      }
      return super.serialize();
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    toJSON() {
      const ret = {
        ...super.toJSON(),
        "RF Region": (0, import_shared.getEnumMemberName)(import_core.RFRegion, this.rfRegion),
        "TX Power": `${this.txPower.toFixed(1)} dBm`,
        "Power @ 0dBm": `${this.measured0dBm.toFixed(1)} dBm`
      };
      if (this.enablePTI != void 0) {
        ret["enable PTI"] = this.enablePTI;
      }
      if (this.maxTXPower != void 0) {
        ret["max TX power"] = `${this.maxTXPower.toFixed(1)} dBm`;
      }
      if (this.nodeIdType != void 0) {
        ret["node ID type"] = (0, import_shared.getEnumMemberName)(import_core.NodeIDType, this.nodeIdType);
      }
      return ret;
    }
  };
  return ApplicationRFConfigFile2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ApplicationRFConfigFile,
  ApplicationRFConfigFileID
});
//# sourceMappingURL=ApplicationRFConfigFile.js.map
