import { Bytes } from "@zwave-js/shared";
import type { NVM3Object } from "../object.js";
import { NVMFile, type NVMFileCreationOptions, type NVMFileDeserializationOptions } from "./NVMFile.js";
export interface ApplicationTypeFileOptions extends NVMFileCreationOptions {
    isListening: boolean;
    optionalFunctionality: boolean;
    genericDeviceClass: number;
    specificDeviceClass: number;
}
export declare const ApplicationTypeFileID = 102;
export declare class ApplicationTypeFile extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | ApplicationTypeFileOptions);
    isListening: boolean;
    optionalFunctionality: boolean;
    genericDeviceClass: number;
    specificDeviceClass: number;
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        listening: boolean;
        "opt. functionality": boolean;
        genericDeviceClass: number;
        specificDeviceClass: number;
    };
}
//# sourceMappingURL=ApplicationTypeFile.d.ts.map