"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NodeInfoFiles_exports = {};
__export(NodeInfoFiles_exports, {
  LRNodeInfoFileV5: () => LRNodeInfoFileV5,
  LRNodeInfoFileV5IDBase: () => LRNodeInfoFileV5IDBase,
  LR_NODEINFOS_PER_FILE_V5: () => LR_NODEINFOS_PER_FILE_V5,
  NODEINFOS_PER_FILE_V1: () => NODEINFOS_PER_FILE_V1,
  NodeInfoFileV0: () => NodeInfoFileV0,
  NodeInfoFileV0IDBase: () => NodeInfoFileV0IDBase,
  NodeInfoFileV1: () => NodeInfoFileV1,
  NodeInfoFileV1IDBase: () => NodeInfoFileV1IDBase,
  nodeIdToLRNodeInfoFileIDV5: () => nodeIdToLRNodeInfoFileIDV5,
  nodeIdToNodeInfoFileIDV0: () => nodeIdToNodeInfoFileIDV0,
  nodeIdToNodeInfoFileIDV1: () => nodeIdToNodeInfoFileIDV1
});
module.exports = __toCommonJS(NodeInfoFiles_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_NVMFile = require("./NVMFile.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
const NODEINFOS_PER_FILE_V1 = 4;
const LR_NODEINFOS_PER_FILE_V5 = 50;
const NODEINFO_SIZE = 1 + 5 + import_core.NUM_NODEMASK_BYTES;
const LR_NODEINFO_SIZE = 3;
const EMPTY_NODEINFO_FILL = 255;
const emptyNodeInfo = new Uint8Array(NODEINFO_SIZE).fill(EMPTY_NODEINFO_FILL);
function parseNodeInfo(nodeId, buffer, offset) {
  const { hasSpecificDeviceClass, ...protocolInfo } = (0, import_core.parseNodeProtocolInfo)(buffer, offset);
  const genericDeviceClass = buffer[offset + 3];
  const specificDeviceClass = hasSpecificDeviceClass ? buffer[offset + 4] : null;
  const neighbors = (0, import_core.parseBitMask)(buffer.subarray(offset + 5, offset + 5 + import_core.NUM_NODEMASK_BYTES));
  const sucUpdateIndex = buffer[offset + 5 + import_core.NUM_NODEMASK_BYTES];
  return {
    nodeId,
    ...protocolInfo,
    genericDeviceClass,
    specificDeviceClass,
    neighbors,
    sucUpdateIndex
  };
}
__name(parseNodeInfo, "parseNodeInfo");
function encodeNodeInfo(nodeInfo) {
  const ret = new import_shared.Bytes(NODEINFO_SIZE);
  const hasSpecificDeviceClass = nodeInfo.specificDeviceClass != null;
  const protocolInfo = {
    ...(0, import_shared.pick)(nodeInfo, [
      "isListening",
      "isFrequentListening",
      "isRouting",
      "supportedDataRates",
      "protocolVersion",
      "optionalFunctionality",
      "nodeType",
      "supportsSecurity",
      "supportsBeaming"
    ]),
    hasSpecificDeviceClass
  };
  ret.set((0, import_core.encodeNodeProtocolInfo)(protocolInfo), 0);
  ret[3] = nodeInfo.genericDeviceClass;
  if (hasSpecificDeviceClass)
    ret[4] = nodeInfo.specificDeviceClass;
  ret.set((0, import_core.encodeBitMask)(nodeInfo.neighbors, import_core.MAX_NODES), 5);
  ret[5 + import_core.NUM_NODEMASK_BYTES] = nodeInfo.sucUpdateIndex;
  return ret;
}
__name(encodeNodeInfo, "encodeNodeInfo");
function parseLRNodeInfo(nodeId, buffer, offset) {
  const capability = buffer[offset];
  const isRouting = !!(capability & 1);
  const isListening = !!(capability & 2);
  const hasSpecificDeviceClass = !!(capability & 4);
  const supportsBeaming = !!(capability & 8);
  const optionalFunctionality = !!(capability & 16);
  let isFrequentListening;
  switch (capability & 96) {
    case 64:
      isFrequentListening = "1000ms";
      break;
    case 32:
      isFrequentListening = "250ms";
      break;
    default:
      isFrequentListening = false;
  }
  const nodeType = import_core.NodeType["End Node"];
  const supportsSecurity = true;
  const protocolVersion = 3;
  const supportedDataRates = [1e5];
  return {
    nodeId,
    isRouting,
    isListening,
    supportsBeaming,
    isFrequentListening,
    optionalFunctionality,
    nodeType,
    supportsSecurity,
    protocolVersion,
    supportedDataRates,
    genericDeviceClass: buffer[offset + 1],
    specificDeviceClass: hasSpecificDeviceClass ? buffer[offset + 2] : null
  };
}
__name(parseLRNodeInfo, "parseLRNodeInfo");
function encodeLRNodeInfo(nodeInfo) {
  const ret = new import_shared.Bytes(LR_NODEINFO_SIZE);
  let capability = 0;
  if (nodeInfo.isRouting)
    capability |= 1;
  if (nodeInfo.isListening)
    capability |= 2;
  if (nodeInfo.specificDeviceClass != null)
    capability |= 4;
  if (nodeInfo.supportsBeaming)
    capability |= 8;
  if (nodeInfo.optionalFunctionality)
    capability |= 16;
  if (nodeInfo.isFrequentListening === "1000ms") {
    capability |= 64;
  } else if (nodeInfo.isFrequentListening === "250ms") {
    capability |= 32;
  }
  ret[0] = capability;
  ret[1] = nodeInfo.genericDeviceClass;
  ret[2] = nodeInfo.specificDeviceClass ?? 0;
  return ret;
}
__name(encodeLRNodeInfo, "encodeLRNodeInfo");
const NodeInfoFileV0IDBase = 327936;
function nodeIdToNodeInfoFileIDV0(nodeId) {
  return NodeInfoFileV0IDBase + nodeId - 1;
}
__name(nodeIdToNodeInfoFileIDV0, "nodeIdToNodeInfoFileIDV0");
let NodeInfoFileV0 = (() => {
  let _classDecorators = [(0, import_NVMFile.nvmFileID)((id) => id >= NodeInfoFileV0IDBase && id < NodeInfoFileV0IDBase + import_core.MAX_NODES), (0, import_NVMFile.nvmSection)("protocol")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_NVMFile.NVMFile;
  var NodeInfoFileV02 = class extends _classSuper {
    static {
      __name(this, "NodeInfoFileV0");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      NodeInfoFileV02 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ((0, import_NVMFile.gotDeserializationOptions)(options)) {
        this.nodeInfo = parseNodeInfo(this.fileId - NodeInfoFileV0IDBase + 1, this.payload, 0);
      } else {
        this.nodeInfo = options.nodeInfo;
      }
    }
    nodeInfo;
    serialize() {
      this.fileId = nodeIdToNodeInfoFileIDV0(this.nodeInfo.nodeId);
      this.payload = encodeNodeInfo(this.nodeInfo);
      return super.serialize();
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    toJSON() {
      return {
        ...super.toJSON(),
        nodeInfo: this.nodeInfo
      };
    }
  };
  return NodeInfoFileV02 = _classThis;
})();
const NodeInfoFileV1IDBase = 328192;
function nodeIdToNodeInfoFileIDV1(nodeId) {
  return NodeInfoFileV1IDBase + Math.floor((nodeId - 1) / NODEINFOS_PER_FILE_V1);
}
__name(nodeIdToNodeInfoFileIDV1, "nodeIdToNodeInfoFileIDV1");
let NodeInfoFileV1 = (() => {
  let _classDecorators = [(0, import_NVMFile.nvmFileID)((id) => id >= NodeInfoFileV1IDBase && id < NodeInfoFileV1IDBase + import_core.MAX_NODES / NODEINFOS_PER_FILE_V1), (0, import_NVMFile.nvmSection)("protocol")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_NVMFile.NVMFile;
  var NodeInfoFileV12 = class extends _classSuper {
    static {
      __name(this, "NodeInfoFileV1");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      NodeInfoFileV12 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ((0, import_NVMFile.gotDeserializationOptions)(options)) {
        this.nodeInfos = [];
        for (let i = 0; i < NODEINFOS_PER_FILE_V1; i++) {
          const nodeId = (this.fileId - NodeInfoFileV1IDBase) * NODEINFOS_PER_FILE_V1 + 1 + i;
          const offset = i * NODEINFO_SIZE;
          const entry = this.payload.subarray(offset, offset + NODEINFO_SIZE);
          if (entry.equals(emptyNodeInfo))
            continue;
          const nodeInfo = parseNodeInfo(nodeId, entry, 0);
          this.nodeInfos.push(nodeInfo);
        }
      } else {
        this.nodeInfos = options.nodeInfos;
      }
    }
    nodeInfos;
    serialize() {
      this.nodeInfos.sort((a, b) => a.nodeId - b.nodeId);
      const minNodeId = this.nodeInfos[0].nodeId;
      this.fileId = nodeIdToNodeInfoFileIDV1(minNodeId);
      this.payload = new import_shared.Bytes(NODEINFO_SIZE * NODEINFOS_PER_FILE_V1).fill(EMPTY_NODEINFO_FILL);
      const minFileNodeId = Math.floor((minNodeId - 1) / NODEINFOS_PER_FILE_V1) * NODEINFOS_PER_FILE_V1 + 1;
      for (const nodeInfo of this.nodeInfos) {
        const offset = (nodeInfo.nodeId - minFileNodeId) * NODEINFO_SIZE;
        this.payload.set(encodeNodeInfo(nodeInfo), offset);
      }
      return super.serialize();
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    toJSON() {
      return {
        ...super.toJSON(),
        "node infos": this.nodeInfos
      };
    }
  };
  return NodeInfoFileV12 = _classThis;
})();
const LRNodeInfoFileV5IDBase = 329728;
function nodeIdToLRNodeInfoFileIDV5(nodeId) {
  return LRNodeInfoFileV5IDBase + Math.floor((nodeId - 256) / LR_NODEINFOS_PER_FILE_V5);
}
__name(nodeIdToLRNodeInfoFileIDV5, "nodeIdToLRNodeInfoFileIDV5");
let LRNodeInfoFileV5 = (() => {
  let _classDecorators = [(0, import_NVMFile.nvmFileID)((id) => id >= LRNodeInfoFileV5IDBase && id < LRNodeInfoFileV5IDBase + import_core.MAX_NODES_LR / LR_NODEINFOS_PER_FILE_V5), (0, import_NVMFile.nvmSection)("protocol")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_NVMFile.NVMFile;
  var LRNodeInfoFileV52 = class extends _classSuper {
    static {
      __name(this, "LRNodeInfoFileV5");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      LRNodeInfoFileV52 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ((0, import_NVMFile.gotDeserializationOptions)(options)) {
        this.nodeInfos = [];
        for (let i = 0; i < LR_NODEINFOS_PER_FILE_V5; i++) {
          const nodeId = (this.fileId - LRNodeInfoFileV5IDBase) * LR_NODEINFOS_PER_FILE_V5 + 256 + i;
          const offset = i * LR_NODEINFO_SIZE;
          const entry = this.payload.subarray(offset, offset + LR_NODEINFO_SIZE);
          if (entry.equals(emptyNodeInfo))
            continue;
          const nodeInfo = parseLRNodeInfo(nodeId, entry, 0);
          this.nodeInfos.push(nodeInfo);
        }
      } else {
        this.nodeInfos = options.nodeInfos;
      }
    }
    nodeInfos;
    serialize() {
      this.nodeInfos.sort((a, b) => a.nodeId - b.nodeId);
      const minNodeId = this.nodeInfos[0].nodeId;
      this.fileId = nodeIdToLRNodeInfoFileIDV5(minNodeId);
      this.payload = new import_shared.Bytes(LR_NODEINFO_SIZE * LR_NODEINFOS_PER_FILE_V5).fill(EMPTY_NODEINFO_FILL);
      const minFileNodeId = Math.floor((minNodeId - 256) / LR_NODEINFOS_PER_FILE_V5) * LR_NODEINFOS_PER_FILE_V5 + 256;
      for (const nodeInfo of this.nodeInfos) {
        const offset = (nodeInfo.nodeId - minFileNodeId) * LR_NODEINFO_SIZE;
        this.payload.set(encodeLRNodeInfo(nodeInfo), offset);
      }
      return super.serialize();
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    toJSON() {
      return {
        ...super.toJSON(),
        "node infos": this.nodeInfos
      };
    }
  };
  return LRNodeInfoFileV52 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  LRNodeInfoFileV5,
  LRNodeInfoFileV5IDBase,
  LR_NODEINFOS_PER_FILE_V5,
  NODEINFOS_PER_FILE_V1,
  NodeInfoFileV0,
  NodeInfoFileV0IDBase,
  NodeInfoFileV1,
  NodeInfoFileV1IDBase,
  nodeIdToLRNodeInfoFileIDV5,
  nodeIdToNodeInfoFileIDV0,
  nodeIdToNodeInfoFileIDV1
});
//# sourceMappingURL=NodeInfoFiles.js.map
