"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EntryParsers_exports = {};
__export(EntryParsers_exports, {
  encodeNVM500NodeInfo: () => encodeNVM500NodeInfo,
  encodeNVMDescriptor: () => encodeNVMDescriptor,
  encodeNVMModuleDescriptor: () => encodeNVMModuleDescriptor,
  parseNVM500NodeInfo: () => parseNVM500NodeInfo,
  parseNVMDescriptor: () => parseNVMDescriptor,
  parseNVMModuleDescriptor: () => parseNVMModuleDescriptor
});
module.exports = __toCommonJS(EntryParsers_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
function parseNVMDescriptor(data, offset = 0) {
  const buffer = import_shared.Bytes.view(data);
  return {
    manufacturerID: buffer.readUInt16BE(offset),
    firmwareID: buffer.readUInt16BE(offset + 2),
    productType: buffer.readUInt16BE(offset + 4),
    productID: buffer.readUInt16BE(offset + 6),
    firmwareVersion: `${buffer[offset + 8]}.${buffer[offset + 9]}`,
    // Z-Wave protocol versions are formatted as "6.07" and similar
    protocolVersion: `${buffer[offset + 10]}.${buffer[offset + 11].toString().padStart(2, "0")}`
  };
}
__name(parseNVMDescriptor, "parseNVMDescriptor");
function encodeNVMDescriptor(descriptor) {
  const ret = new import_shared.Bytes(12);
  ret.writeUInt16BE(descriptor.manufacturerID, 0);
  ret.writeUInt16BE(descriptor.firmwareID, 2);
  ret.writeUInt16BE(descriptor.productType, 4);
  ret.writeUInt16BE(descriptor.productID, 6);
  const fwVersionParts = descriptor.firmwareVersion.split(".").map((i) => parseInt(i));
  ret[8] = fwVersionParts[0];
  ret[9] = fwVersionParts[1];
  const protocolVersionParts = descriptor.protocolVersion.split(".").map((i) => parseInt(i));
  ret[10] = protocolVersionParts[0];
  ret[11] = protocolVersionParts[1];
  return ret;
}
__name(encodeNVMDescriptor, "encodeNVMDescriptor");
function parseNVMModuleDescriptor(data, offset = 0) {
  const buffer = import_shared.Bytes.view(data);
  return {
    size: buffer.readUInt16BE(offset),
    type: buffer[offset + 2],
    version: `${buffer[offset + 3]}.${buffer[offset + 4]}`
  };
}
__name(parseNVMModuleDescriptor, "parseNVMModuleDescriptor");
function encodeNVMModuleDescriptor(descriptior) {
  const ret = new import_shared.Bytes(5);
  ret.writeUInt16BE(descriptior.size, 0);
  ret[2] = descriptior.type;
  const versionParts = descriptior.version.split(".").map((i) => parseInt(i));
  ret[3] = versionParts[0];
  ret[4] = versionParts[1];
  return ret;
}
__name(encodeNVMModuleDescriptor, "encodeNVMModuleDescriptor");
function parseNVM500NodeInfo(buffer, offset) {
  const { hasSpecificDeviceClass, ...protocolInfo } = (0, import_core.parseNodeProtocolInfo)(buffer, offset);
  const genericDeviceClass = buffer[offset + 3];
  const specificDeviceClass = hasSpecificDeviceClass ? buffer[offset + 4] : null;
  return {
    ...protocolInfo,
    genericDeviceClass,
    specificDeviceClass
  };
}
__name(parseNVM500NodeInfo, "parseNVM500NodeInfo");
function encodeNVM500NodeInfo(nodeInfo) {
  return import_shared.Bytes.concat([
    (0, import_core.encodeNodeProtocolInfo)({
      ...nodeInfo,
      hasSpecificDeviceClass: !!nodeInfo.specificDeviceClass
    }),
    import_shared.Bytes.from([
      nodeInfo.genericDeviceClass,
      nodeInfo.specificDeviceClass ?? 0
    ])
  ]);
}
__name(encodeNVM500NodeInfo, "encodeNVM500NodeInfo");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  encodeNVM500NodeInfo,
  encodeNVMDescriptor,
  encodeNVMModuleDescriptor,
  parseNVM500NodeInfo,
  parseNVMDescriptor,
  parseNVMModuleDescriptor
});
//# sourceMappingURL=EntryParsers.js.map
