import type { Bytes } from "@zwave-js/shared";
import type { NVM3Object } from "../object.js";
import { NVMFile, type NVMFileCreationOptions, type NVMFileDeserializationOptions } from "./NVMFile.js";
export interface ProtocolNodeMaskFileOptions extends NVMFileCreationOptions {
    nodeIds: number[];
}
export declare class ProtocolNodeMaskFile extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | ProtocolNodeMaskFileOptions);
    nodeIdSet: Set<number>;
    get nodeIds(): number[];
    set nodeIds(value: number[]);
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        "node IDs": string;
    };
}
export declare const ProtocolPreferredRepeatersFileID = 327682;
export declare class ProtocolPreferredRepeatersFile extends ProtocolNodeMaskFile {
}
export declare const ProtocolNodeListFileID = 327685;
export declare class ProtocolNodeListFile extends ProtocolNodeMaskFile {
}
export declare const ProtocolAppRouteLockNodeMaskFileID = 327686;
export declare class ProtocolAppRouteLockNodeMaskFile extends ProtocolNodeMaskFile {
}
export declare const ProtocolRouteSlaveSUCNodeMaskFileID = 327687;
export declare class ProtocolRouteSlaveSUCNodeMaskFile extends ProtocolNodeMaskFile {
}
export declare const ProtocolSUCPendingUpdateNodeMaskFileID = 327688;
export declare class ProtocolSUCPendingUpdateNodeMaskFile extends ProtocolNodeMaskFile {
}
export declare const ProtocolVirtualNodeMaskFileID = 327689;
export declare class ProtocolVirtualNodeMaskFile extends ProtocolNodeMaskFile {
}
export declare const ProtocolPendingDiscoveryNodeMaskFileID = 327690;
export declare class ProtocolPendingDiscoveryNodeMaskFile extends ProtocolNodeMaskFile {
}
export declare const ProtocolRouteCacheExistsNodeMaskFileID = 327691;
export declare class ProtocolRouteCacheExistsNodeMaskFile extends ProtocolNodeMaskFile {
}
export declare const ProtocolLRNodeListFileID = 327692;
export declare class ProtocolLRNodeListFile extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | ProtocolNodeMaskFileOptions);
    nodeIdSet: Set<number>;
    get nodeIds(): number[];
    set nodeIds(value: number[]);
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        "node IDs": string;
    };
}
//# sourceMappingURL=ProtocolNodeMaskFiles.d.ts.map