var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { NODE_ID_MAX, encodeBitMask, parseBitMask } from "@zwave-js/core";
import { NVMFile, gotDeserializationOptions, nvmFileID, nvmSection, } from "./NVMFile.js";
export class ProtocolNodeMaskFile extends NVMFile {
    constructor(options) {
        super(options);
        if (gotDeserializationOptions(options)) {
            this.nodeIdSet = new Set(parseBitMask(this.payload));
        }
        else {
            this.nodeIdSet = new Set(options.nodeIds);
        }
    }
    nodeIdSet;
    get nodeIds() {
        return [...this.nodeIdSet];
    }
    set nodeIds(value) {
        this.nodeIdSet = new Set(value);
    }
    serialize() {
        this.payload = encodeBitMask([...this.nodeIdSet], NODE_ID_MAX);
        return super.serialize();
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    toJSON() {
        return {
            ...super.toJSON(),
            "node IDs": [...this.nodeIdSet].join(", "),
        };
    }
}
export const ProtocolPreferredRepeatersFileID = 0x50002;
let ProtocolPreferredRepeatersFile = (() => {
    let _classDecorators = [nvmFileID(ProtocolPreferredRepeatersFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ProtocolNodeMaskFile;
    var ProtocolPreferredRepeatersFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ProtocolPreferredRepeatersFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ProtocolPreferredRepeatersFile = _classThis;
})();
export { ProtocolPreferredRepeatersFile };
export const ProtocolNodeListFileID = 0x50005;
let ProtocolNodeListFile = (() => {
    let _classDecorators = [nvmFileID(ProtocolNodeListFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ProtocolNodeMaskFile;
    var ProtocolNodeListFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ProtocolNodeListFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ProtocolNodeListFile = _classThis;
})();
export { ProtocolNodeListFile };
export const ProtocolAppRouteLockNodeMaskFileID = 0x50006;
let ProtocolAppRouteLockNodeMaskFile = (() => {
    let _classDecorators = [nvmFileID(ProtocolAppRouteLockNodeMaskFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ProtocolNodeMaskFile;
    var ProtocolAppRouteLockNodeMaskFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ProtocolAppRouteLockNodeMaskFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ProtocolAppRouteLockNodeMaskFile = _classThis;
})();
export { ProtocolAppRouteLockNodeMaskFile };
export const ProtocolRouteSlaveSUCNodeMaskFileID = 0x50007;
let ProtocolRouteSlaveSUCNodeMaskFile = (() => {
    let _classDecorators = [nvmFileID(ProtocolRouteSlaveSUCNodeMaskFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ProtocolNodeMaskFile;
    var ProtocolRouteSlaveSUCNodeMaskFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ProtocolRouteSlaveSUCNodeMaskFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ProtocolRouteSlaveSUCNodeMaskFile = _classThis;
})();
export { ProtocolRouteSlaveSUCNodeMaskFile };
export const ProtocolSUCPendingUpdateNodeMaskFileID = 0x50008;
let ProtocolSUCPendingUpdateNodeMaskFile = (() => {
    let _classDecorators = [nvmFileID(ProtocolSUCPendingUpdateNodeMaskFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ProtocolNodeMaskFile;
    var ProtocolSUCPendingUpdateNodeMaskFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ProtocolSUCPendingUpdateNodeMaskFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ProtocolSUCPendingUpdateNodeMaskFile = _classThis;
})();
export { ProtocolSUCPendingUpdateNodeMaskFile };
export const ProtocolVirtualNodeMaskFileID = 0x50009;
let ProtocolVirtualNodeMaskFile = (() => {
    let _classDecorators = [nvmFileID(ProtocolVirtualNodeMaskFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ProtocolNodeMaskFile;
    var ProtocolVirtualNodeMaskFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ProtocolVirtualNodeMaskFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ProtocolVirtualNodeMaskFile = _classThis;
})();
export { ProtocolVirtualNodeMaskFile };
export const ProtocolPendingDiscoveryNodeMaskFileID = 0x5000a;
let ProtocolPendingDiscoveryNodeMaskFile = (() => {
    let _classDecorators = [nvmFileID(ProtocolPendingDiscoveryNodeMaskFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ProtocolNodeMaskFile;
    var ProtocolPendingDiscoveryNodeMaskFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ProtocolPendingDiscoveryNodeMaskFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ProtocolPendingDiscoveryNodeMaskFile = _classThis;
})();
export { ProtocolPendingDiscoveryNodeMaskFile };
export const ProtocolRouteCacheExistsNodeMaskFileID = 0x5000b;
let ProtocolRouteCacheExistsNodeMaskFile = (() => {
    let _classDecorators = [nvmFileID(ProtocolRouteCacheExistsNodeMaskFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ProtocolNodeMaskFile;
    var ProtocolRouteCacheExistsNodeMaskFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ProtocolRouteCacheExistsNodeMaskFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ProtocolRouteCacheExistsNodeMaskFile = _classThis;
})();
export { ProtocolRouteCacheExistsNodeMaskFile };
export const ProtocolLRNodeListFileID = 0x5000c;
let ProtocolLRNodeListFile = (() => {
    let _classDecorators = [nvmFileID(ProtocolLRNodeListFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = NVMFile;
    var ProtocolLRNodeListFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ProtocolLRNodeListFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (gotDeserializationOptions(options)) {
                this.nodeIdSet = new Set(parseBitMask(this.payload, 256));
            }
            else {
                this.nodeIdSet = new Set(options.nodeIds);
            }
        }
        nodeIdSet;
        get nodeIds() {
            return [...this.nodeIdSet];
        }
        set nodeIds(value) {
            this.nodeIdSet = new Set(value);
        }
        serialize() {
            // There are only 128 bytes for the bitmask, so the LR node IDs only go up to 1279
            this.payload = encodeBitMask([...this.nodeIdSet], 1279, 256);
            return super.serialize();
        }
        // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
        toJSON() {
            return {
                ...super.toJSON(),
                "node IDs": [...this.nodeIdSet].join(", "),
            };
        }
    };
    return ProtocolLRNodeListFile = _classThis;
})();
export { ProtocolLRNodeListFile };
//# sourceMappingURL=ProtocolNodeMaskFiles.js.map