import { Bytes } from "@zwave-js/shared";
import type { NVM3Object } from "../object.js";
import { NVMFile, type NVMFileCreationOptions, type NVMFileDeserializationOptions } from "./NVMFile.js";
export interface VersionFileOptions extends NVMFileCreationOptions {
    format: number;
    major: number;
    minor: number;
    patch: number;
}
export declare class VersionFile extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | VersionFileOptions);
    format: number;
    major: number;
    minor: number;
    patch: number;
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        format: number;
        version: string;
    };
}
export declare const ApplicationVersionFileID = 331776;
export declare class ApplicationVersionFile extends VersionFile {
}
export declare const ApplicationVersionFile800ID = 266240;
export declare class ApplicationVersionFile800 extends VersionFile {
}
export declare const ProtocolVersionFileID = 327680;
export declare class ProtocolVersionFile extends VersionFile {
}
//# sourceMappingURL=VersionFiles.d.ts.map