import { FunctionType, Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare class GetSerialApiCapabilitiesRequest extends Message {
}
export interface GetSerialApiCapabilitiesResponseOptions {
    firmwareVersion: string;
    manufacturerId: number;
    productType: number;
    productId: number;
    supportedFunctionTypes: FunctionType[];
}
export declare class GetSerialApiCapabilitiesResponse extends Message {
    constructor(options: GetSerialApiCapabilitiesResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): GetSerialApiCapabilitiesResponse;
    firmwareVersion: string;
    manufacturerId: number;
    productType: number;
    productId: number;
    supportedFunctionTypes: FunctionType[];
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
//# sourceMappingURL=GetSerialApiCapabilitiesMessages.d.ts.map