import { type MessageOrCCLogEntry, TransmitStatus, ZWaveDataRate } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare class AssignPrioritySUCReturnRouteRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): AssignPrioritySUCReturnRouteRequestBase;
}
export interface AssignPrioritySUCReturnRouteRequestOptions {
    nodeId: number;
    repeaters: number[];
    routeSpeed: ZWaveDataRate;
}
export declare class AssignPrioritySUCReturnRouteRequest extends AssignPrioritySUCReturnRouteRequestBase {
    constructor(options: AssignPrioritySUCReturnRouteRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): AssignPrioritySUCReturnRouteRequest;
    nodeId: number;
    repeaters: number[];
    routeSpeed: ZWaveDataRate;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface AssignPrioritySUCReturnRouteResponseOptions {
    hasStarted: boolean;
}
export declare class AssignPrioritySUCReturnRouteResponse extends Message implements SuccessIndicator {
    constructor(options: AssignPrioritySUCReturnRouteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): AssignPrioritySUCReturnRouteResponse;
    isOK(): boolean;
    readonly hasStarted: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface AssignPrioritySUCReturnRouteRequestTransmitReportOptions {
    transmitStatus: TransmitStatus;
}
export declare class AssignPrioritySUCReturnRouteRequestTransmitReport extends AssignPrioritySUCReturnRouteRequestBase implements SuccessIndicator {
    constructor(options: AssignPrioritySUCReturnRouteRequestTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): AssignPrioritySUCReturnRouteRequestTransmitReport;
    isOK(): boolean;
    readonly transmitStatus: TransmitStatus;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=AssignPrioritySUCReturnRouteMessages.d.ts.map