"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var AssignSUCReturnRouteMessages_exports = {};
__export(AssignSUCReturnRouteMessages_exports, {
  AssignSUCReturnRouteRequest: () => AssignSUCReturnRouteRequest,
  AssignSUCReturnRouteRequestBase: () => AssignSUCReturnRouteRequestBase,
  AssignSUCReturnRouteRequestTransmitReport: () => AssignSUCReturnRouteRequestTransmitReport,
  AssignSUCReturnRouteResponse: () => AssignSUCReturnRouteResponse
});
module.exports = __toCommonJS(AssignSUCReturnRouteMessages_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let AssignSUCReturnRouteRequestBase = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.AssignSUCReturnRoute), (0, import_serial.priority)(import_core.MessagePriority.Normal)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var AssignSUCReturnRouteRequestBase2 = class extends _classSuper {
    static {
      __name(this, "AssignSUCReturnRouteRequestBase");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssignSUCReturnRouteRequestBase2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      if (ctx.origin === import_serial.MessageOrigin.Host) {
        return AssignSUCReturnRouteRequest.from(raw, ctx);
      } else {
        return AssignSUCReturnRouteRequestTransmitReport.from(raw, ctx);
      }
    }
  };
  return AssignSUCReturnRouteRequestBase2 = _classThis;
})();
function testAssignSUCReturnRouteCallback(sent, callback) {
  if (sent.disableCallbackFunctionTypeCheck) {
    return true;
  }
  return callback.functionType === import_serial.FunctionType.AssignSUCReturnRoute;
}
__name(testAssignSUCReturnRouteCallback, "testAssignSUCReturnRouteCallback");
let AssignSUCReturnRouteRequest = (() => {
  let _classDecorators = [(0, import_serial.expectedResponse)(import_serial.FunctionType.AssignSUCReturnRoute), (0, import_serial.expectedCallback)(testAssignSUCReturnRouteCallback)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssignSUCReturnRouteRequestBase;
  var AssignSUCReturnRouteRequest2 = class extends _classSuper {
    static {
      __name(this, "AssignSUCReturnRouteRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssignSUCReturnRouteRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.nodeId = options.nodeId;
      this.disableCallbackFunctionTypeCheck = options.disableCallbackFunctionTypeCheck;
    }
    static from(raw, _ctx) {
      const nodeId = raw.payload[0];
      const callbackId = raw.payload[1];
      return new this({
        nodeId,
        callbackId
      });
    }
    nodeId;
    disableCallbackFunctionTypeCheck;
    serialize(ctx) {
      this.assertCallbackId();
      const nodeId = (0, import_core.encodeNodeID)(this.nodeId, ctx.nodeIdType);
      this.payload = import_shared.Bytes.concat([nodeId, import_shared.Bytes.from([this.callbackId])]);
      return super.serialize(ctx);
    }
  };
  return AssignSUCReturnRouteRequest2 = _classThis;
})();
let AssignSUCReturnRouteResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.AssignSUCReturnRoute)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var AssignSUCReturnRouteResponse2 = class extends _classSuper {
    static {
      __name(this, "AssignSUCReturnRouteResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssignSUCReturnRouteResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.wasExecuted = options.wasExecuted;
    }
    static from(raw, _ctx) {
      const wasExecuted = raw.payload[0] !== 0;
      return new this({
        wasExecuted
      });
    }
    isOK() {
      return this.wasExecuted;
    }
    wasExecuted;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.wasExecuted ? 1 : 0]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: { "was executed": this.wasExecuted }
      };
    }
  };
  return AssignSUCReturnRouteResponse2 = _classThis;
})();
class AssignSUCReturnRouteRequestTransmitReport extends AssignSUCReturnRouteRequestBase {
  static {
    __name(this, "AssignSUCReturnRouteRequestTransmitReport");
  }
  constructor(options) {
    super(options);
    this.callbackId = options.callbackId;
    this.transmitStatus = options.transmitStatus;
  }
  static from(raw, _ctx) {
    const callbackId = raw.payload[0];
    const transmitStatus = raw.payload[1];
    return new this({
      callbackId,
      transmitStatus
    });
  }
  isOK() {
    return this.transmitStatus !== import_core.TransmitStatus.NoAck;
  }
  transmitStatus;
  serialize(ctx) {
    this.assertCallbackId();
    this.payload = import_shared.Bytes.from([this.callbackId, this.transmitStatus]);
    return super.serialize(ctx);
  }
  toLogEntry() {
    return {
      ...super.toLogEntry(),
      message: {
        "callback id": this.callbackId ?? "(not set)",
        "transmit status": (0, import_shared.getEnumMemberName)(import_core.TransmitStatus, this.transmitStatus)
      }
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AssignSUCReturnRouteRequest,
  AssignSUCReturnRouteRequestBase,
  AssignSUCReturnRouteRequestTransmitReport,
  AssignSUCReturnRouteResponse
});
//# sourceMappingURL=AssignSUCReturnRouteMessages.js.map
