"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SetSUCNodeIDMessages_exports = {};
__export(SetSUCNodeIDMessages_exports, {
  SetSUCNodeIdRequest: () => SetSUCNodeIdRequest,
  SetSUCNodeIdRequestBase: () => SetSUCNodeIdRequestBase,
  SetSUCNodeIdRequestStatusReport: () => SetSUCNodeIdRequestStatusReport,
  SetSUCNodeIdResponse: () => SetSUCNodeIdResponse,
  SetSUCNodeIdStatus: () => SetSUCNodeIdStatus
});
module.exports = __toCommonJS(SetSUCNodeIDMessages_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var SetSUCNodeIdStatus;
(function(SetSUCNodeIdStatus2) {
  SetSUCNodeIdStatus2[SetSUCNodeIdStatus2["Succeeded"] = 5] = "Succeeded";
  SetSUCNodeIdStatus2[SetSUCNodeIdStatus2["Failed"] = 6] = "Failed";
})(SetSUCNodeIdStatus || (SetSUCNodeIdStatus = {}));
let SetSUCNodeIdRequestBase = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.SetSUCNodeId), (0, import_serial.priority)(import_core.MessagePriority.Controller)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SetSUCNodeIdRequestBase2 = class extends _classSuper {
    static {
      __name(this, "SetSUCNodeIdRequestBase");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SetSUCNodeIdRequestBase2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      if (ctx.origin === import_serial.MessageOrigin.Host) {
        return SetSUCNodeIdRequest.from(raw, ctx);
      } else {
        return SetSUCNodeIdRequestStatusReport.from(raw, ctx);
      }
    }
  };
  return SetSUCNodeIdRequestBase2 = _classThis;
})();
let SetSUCNodeIdRequest = (() => {
  let _classDecorators = [(0, import_serial.expectedResponse)(import_serial.FunctionType.SetSUCNodeId), (0, import_serial.expectedCallback)(import_serial.FunctionType.SetSUCNodeId)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SetSUCNodeIdRequestBase;
  var SetSUCNodeIdRequest2 = class extends _classSuper {
    static {
      __name(this, "SetSUCNodeIdRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SetSUCNodeIdRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sucNodeId = options.sucNodeId;
      this.enableSUC = options.enableSUC;
      this.enableSIS = options.enableSIS;
      this.transmitOptions = options.transmitOptions ?? import_core.TransmitOptions.DEFAULT;
      this._ownNodeId = options.ownNodeId;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    sucNodeId;
    enableSUC;
    enableSIS;
    transmitOptions;
    _ownNodeId;
    serialize(ctx) {
      this.assertCallbackId();
      const nodeId = (0, import_core.encodeNodeID)(this.sucNodeId, ctx.nodeIdType);
      this.payload = import_shared.Bytes.concat([
        nodeId,
        import_shared.Bytes.from([
          this.enableSUC ? 1 : 0,
          this.transmitOptions,
          this.enableSIS ? 1 : 0,
          this.callbackId
        ])
      ]);
      return super.serialize(ctx);
    }
    expectsCallback() {
      if (this.sucNodeId === this._ownNodeId)
        return false;
      return super.expectsCallback();
    }
  };
  return SetSUCNodeIdRequest2 = _classThis;
})();
let SetSUCNodeIdResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.SetSUCNodeId)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SetSUCNodeIdResponse2 = class extends _classSuper {
    static {
      __name(this, "SetSUCNodeIdResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SetSUCNodeIdResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.wasExecuted = options.wasExecuted;
    }
    static from(raw, _ctx) {
      const wasExecuted = raw.payload[0] !== 0;
      return new this({
        wasExecuted
      });
    }
    isOK() {
      return this.wasExecuted;
    }
    wasExecuted;
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: { "was executed": this.wasExecuted }
      };
    }
  };
  return SetSUCNodeIdResponse2 = _classThis;
})();
class SetSUCNodeIdRequestStatusReport extends SetSUCNodeIdRequestBase {
  static {
    __name(this, "SetSUCNodeIdRequestStatusReport");
  }
  constructor(options) {
    super(options);
    this.callbackId = options.callbackId;
    this.status = options.status;
  }
  static from(raw, _ctx) {
    const callbackId = raw.payload[0];
    const status = raw.payload[1];
    return new this({
      callbackId,
      status
    });
  }
  status;
  isOK() {
    return this.status === SetSUCNodeIdStatus.Succeeded;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SetSUCNodeIdRequest,
  SetSUCNodeIdRequestBase,
  SetSUCNodeIdRequestStatusReport,
  SetSUCNodeIdResponse,
  SetSUCNodeIdStatus
});
//# sourceMappingURL=SetSUCNodeIDMessages.js.map
