import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes, type BytesView } from "@zwave-js/shared";
export interface ExtNVMReadLongBufferRequestOptions {
    offset: number;
    length: number;
}
export declare class ExtNVMReadLongBufferRequest extends Message {
    constructor(options: ExtNVMReadLongBufferRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): ExtNVMReadLongBufferRequest;
    offset: number;
    length: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface ExtNVMReadLongBufferResponseOptions {
    buffer: BytesView;
}
export declare class ExtNVMReadLongBufferResponse extends Message {
    constructor(options: ExtNVMReadLongBufferResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): ExtNVMReadLongBufferResponse;
    readonly buffer: BytesView;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=ExtNVMReadLongBufferMessages.d.ts.map