import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export interface ExtNVMReadLongByteRequestOptions {
    offset: number;
}
export declare class ExtNVMReadLongByteRequest extends Message {
    constructor(options: ExtNVMReadLongByteRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): ExtNVMReadLongByteRequest;
    offset: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface ExtNVMReadLongByteResponseOptions {
    byte: number;
}
export declare class ExtNVMReadLongByteResponse extends Message {
    constructor(options: ExtNVMReadLongByteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): ExtNVMReadLongByteResponse;
    readonly byte: number;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=ExtNVMReadLongByteMessages.d.ts.map