import type { CCEncodingContext, CommandClass } from "@zwave-js/cc";
import { type MessageOrCCLogEntry, type MulticastCC, type MulticastDestination, type SinglecastCC, type TXReport, TransmitOptions, TransmitStatus } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes, type BytesView } from "@zwave-js/shared";
import { type MessageWithCC } from "../utils.js";
export declare class SendDataBridgeRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): SendDataBridgeRequestBase;
}
export type SendDataBridgeRequestOptions<CCType extends CommandClass = CommandClass> = ({
    command: CCType;
} | {
    nodeId: number;
    serializedCC: BytesView;
}) & {
    sourceNodeId: number;
    transmitOptions?: TransmitOptions;
    maxSendAttempts?: number;
};
export declare class SendDataBridgeRequest<CCType extends CommandClass = CommandClass> extends SendDataBridgeRequestBase implements MessageWithCC {
    constructor(options: SendDataBridgeRequestOptions<CCType> & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): SendDataBridgeRequestBase;
    /** Which Node ID this command originates from */
    sourceNodeId: number;
    /** The command this message contains */
    command: SinglecastCC<CCType> | undefined;
    /** Options regarding the transmission of the message */
    transmitOptions: TransmitOptions;
    private _maxSendAttempts;
    /** The number of times the driver may try to send this message */
    get maxSendAttempts(): number;
    set maxSendAttempts(value: number);
    private _nodeId;
    getNodeId(): number | undefined;
    serializedCC: BytesView | undefined;
    serializeCC(ctx: CCEncodingContext): Promise<BytesView>;
    prepareRetransmission(): void;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
    expectsNodeUpdate(): boolean;
    isExpectedNodeUpdate(msg: Message): boolean;
}
export interface SendDataBridgeRequestTransmitReportOptions {
    transmitStatus: TransmitStatus;
    txReport?: TXReport;
}
export declare class SendDataBridgeRequestTransmitReport extends SendDataBridgeRequestBase implements SuccessIndicator {
    constructor(options: SendDataBridgeRequestTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SendDataBridgeRequestTransmitReport;
    readonly transmitStatus: TransmitStatus;
    readonly txReport: TXReport | undefined;
    isOK(): boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SendDataBridgeResponseOptions {
    wasSent: boolean;
}
export declare class SendDataBridgeResponse extends Message implements SuccessIndicator {
    constructor(options: SendDataBridgeResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SendDataBridgeResponse;
    isOK(): boolean;
    wasSent: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SendDataMulticastBridgeRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): SendDataMulticastBridgeRequestBase;
}
export type SendDataMulticastBridgeRequestOptions<CCType extends CommandClass> = ({
    command: CCType;
} | {
    nodeIds: MulticastDestination;
    serializedCC: BytesView;
}) & {
    sourceNodeId: number;
    transmitOptions?: TransmitOptions;
    maxSendAttempts?: number;
};
export declare class SendDataMulticastBridgeRequest<CCType extends CommandClass = CommandClass> extends SendDataMulticastBridgeRequestBase implements MessageWithCC {
    constructor(options: SendDataMulticastBridgeRequestOptions<CCType> & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): SendDataMulticastBridgeRequest;
    /** Which Node ID this command originates from */
    sourceNodeId: number;
    /** The command this message contains */
    command: MulticastCC<CCType> | undefined;
    /** Options regarding the transmission of the message */
    transmitOptions: TransmitOptions;
    private _maxSendAttempts;
    /** The number of times the driver may try to send this message */
    get maxSendAttempts(): number;
    set maxSendAttempts(value: number);
    nodeIds: MulticastDestination;
    getNodeId(): number | undefined;
    serializedCC: BytesView | undefined;
    serializeCC(ctx: CCEncodingContext): Promise<BytesView>;
    prepareRetransmission(): void;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SendDataMulticastBridgeRequestTransmitReportOptions {
    transmitStatus: TransmitStatus;
}
export declare class SendDataMulticastBridgeRequestTransmitReport extends SendDataMulticastBridgeRequestBase implements SuccessIndicator {
    constructor(options: SendDataMulticastBridgeRequestTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SendDataMulticastBridgeRequestTransmitReport;
    transmitStatus: TransmitStatus;
    isOK(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SendDataMulticastBridgeResponseOptions {
    wasSent: boolean;
}
export declare class SendDataMulticastBridgeResponse extends Message implements SuccessIndicator {
    constructor(options: SendDataMulticastBridgeResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SendDataMulticastBridgeResponse;
    isOK(): boolean;
    wasSent: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=SendDataBridgeMessages.d.ts.map