import { type MessageRecord, type RSSI, type SerializableTXReport, type TXReport } from "@zwave-js/core";
import { type BytesView } from "@zwave-js/shared";
import { AssignPriorityReturnRouteRequestTransmitReport } from "../network-mgmt/AssignPriorityReturnRouteMessages.js";
import { AssignPrioritySUCReturnRouteRequestTransmitReport } from "../network-mgmt/AssignPrioritySUCReturnRouteMessages.js";
import { AssignReturnRouteRequestTransmitReport } from "../network-mgmt/AssignReturnRouteMessages.js";
import { AssignSUCReturnRouteRequestTransmitReport } from "../network-mgmt/AssignSUCReturnRouteMessages.js";
import { DeleteReturnRouteRequestTransmitReport } from "../network-mgmt/DeleteReturnRouteMessages.js";
import { DeleteSUCReturnRouteRequestTransmitReport } from "../network-mgmt/DeleteSUCReturnRouteMessages.js";
import { SendDataBridgeRequest, SendDataBridgeRequestTransmitReport, SendDataBridgeResponse, SendDataMulticastBridgeRequest, SendDataMulticastBridgeRequestTransmitReport, SendDataMulticastBridgeResponse } from "./SendDataBridgeMessages.js";
import { SendDataMulticastRequest, SendDataMulticastRequestTransmitReport, SendDataMulticastResponse, SendDataRequest, SendDataRequestTransmitReport, SendDataResponse } from "./SendDataMessages.js";
export type SendDataMessage = SendDataRequest | SendDataMulticastRequest | SendDataBridgeRequest | SendDataMulticastBridgeRequest;
export type AnySendDataResponse = SendDataResponse | SendDataMulticastResponse | SendDataBridgeResponse | SendDataMulticastBridgeResponse;
export type SendDataTransmitReport = SendDataRequestTransmitReport | SendDataMulticastRequestTransmitReport | SendDataBridgeRequestTransmitReport | SendDataMulticastBridgeRequestTransmitReport;
/** All message classes that are a callback with a transmit report */
export type TransmitReport = SendDataTransmitReport | AssignReturnRouteRequestTransmitReport | AssignSUCReturnRouteRequestTransmitReport | AssignPriorityReturnRouteRequestTransmitReport | AssignPrioritySUCReturnRouteRequestTransmitReport | DeleteReturnRouteRequestTransmitReport | DeleteSUCReturnRouteRequestTransmitReport;
export declare function parseRSSI(payload: BytesView, offset?: number): RSSI;
export declare function tryParseRSSI(payload: BytesView, offset?: number): RSSI | undefined;
/**
 * Parses a TX report returned by a SendData callback
 * @param includeACK whether ACK related fields should be parsed
 */
export declare function parseTXReport(includeACK: boolean, payload: BytesView): TXReport | undefined;
export declare function serializableTXReportToTXReport(report: SerializableTXReport): TXReport;
export declare function encodeTXReport(report: SerializableTXReport): BytesView;
export declare function txReportToMessageRecord(report: TXReport): MessageRecord;
export declare function isSendData(msg: unknown): msg is SendDataMessage;
export declare function isAnySendDataResponse(msg: unknown): msg is AnySendDataResponse;
export declare function isSendDataSinglecast(msg: unknown): msg is SendDataRequest | SendDataBridgeRequest;
export declare function isSendDataMulticast(msg: unknown): msg is SendDataMulticastRequest | SendDataMulticastBridgeRequest;
export declare function isSendDataTransmitReport(msg: unknown): msg is SendDataTransmitReport;
export declare function isTransmitReport(msg: unknown): msg is TransmitReport;
export declare function hasTXReport(msg: unknown): msg is (SendDataRequestTransmitReport | SendDataBridgeRequestTransmitReport) & {
    txReport: TXReport;
};
//# sourceMappingURL=SendDataShared.d.ts.map