"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NodeSerialPort_exports = {};
__export(NodeSerialPort_exports, {
  createNodeSerialPortFactory: () => createNodeSerialPortFactory
});
module.exports = __toCommonJS(NodeSerialPort_exports);
var import_core = require("@zwave-js/core");
var import_serialport = require("serialport");
function createNodeSerialPortFactory(port, Binding = import_serialport.SerialPort) {
  return async function() {
    const serial = new Binding({
      path: port,
      autoOpen: false,
      baudRate: 115200,
      dataBits: 8,
      stopBits: 1,
      parity: "none"
    });
    let isOpen = serial.isOpen;
    function removeListeners() {
      serial.removeAllListeners("close");
      serial.removeAllListeners("error");
      serial.removeAllListeners("open");
    }
    __name(removeListeners, "removeListeners");
    async function close() {
      if (!isOpen)
        return;
      isOpen = false;
      return new Promise((resolve) => {
        removeListeners();
        serial.once("close", resolve);
        serial.close();
      });
    }
    __name(close, "close");
    function open() {
      return new Promise((resolve, reject) => {
        const onClose = /* @__PURE__ */ __name(() => {
          removeListeners();
          reject(new import_core.ZWaveError(`The serial port closed unexpectedly!`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
        }, "onClose");
        const onError = /* @__PURE__ */ __name((err) => {
          removeListeners();
          reject(err);
        }, "onError");
        const onOpen = /* @__PURE__ */ __name(() => {
          removeListeners();
          isOpen = true;
          resolve();
        }, "onOpen");
        serial.once("close", onClose);
        serial.once("error", onError);
        serial.once("open", onOpen);
        serial.open();
      });
    }
    __name(open, "open");
    await close();
    await open();
    const sink = {
      start(controller) {
        serial.on("error", (err) => controller.error(err));
      },
      write(data, controller) {
        if (!isOpen) {
          controller.error(new Error("The serial port is not open!"));
        }
        return new Promise((resolve, reject) => {
          serial.write(data, (err) => {
            if (err)
              reject(err);
            else
              resolve();
          });
        });
      },
      close() {
        return close();
      },
      abort(_reason) {
        return close();
      }
    };
    const source = {
      start(controller) {
        serial.on("data", (data) => controller.enqueue(data));
        serial.on("close", (err) => {
          if (err?.disconnected === true) {
            isOpen = false;
            controller.error(new import_core.ZWaveError(`The serial port closed unexpectedly!`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
          }
        });
      },
      cancel() {
        serial.removeAllListeners();
      }
    };
    return { source, sink };
  };
}
__name(createNodeSerialPortFactory, "createNodeSerialPortFactory");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createNodeSerialPortFactory
});
//# sourceMappingURL=NodeSerialPort.js.map
