import { Bytes } from "@zwave-js/shared";
import { ESPHomeMessage, type ESPHomeMessageBaseOptions, type ESPHomeMessageRaw } from "./ESPHomeMessage.js";
export declare class DeviceInfoRequest extends ESPHomeMessage {
}
export interface DeviceInfoResponseOptions extends ESPHomeMessageBaseOptions {
    usesPassword?: boolean;
    name?: string;
    macAddress?: string;
    esphomeVersion?: string;
    compilationTime?: string;
    model?: string;
    hasDeepSleep?: boolean;
    projectName?: string;
    projectVersion?: string;
    webserverPort?: number;
    manufacturer?: string;
    friendlyName?: string;
    suggestedArea?: string;
    bluetoothMacAddress?: string;
    apiEncryptionSupported?: boolean;
    zwaveProxyFeatureFlags?: number;
}
export declare class DeviceInfoResponse extends ESPHomeMessage {
    constructor(options: DeviceInfoResponseOptions);
    static from(raw: ESPHomeMessageRaw): DeviceInfoResponse;
    usesPassword: boolean;
    name: string;
    macAddress: string;
    esphomeVersion: string;
    compilationTime: string;
    model: string;
    hasDeepSleep: boolean;
    projectName: string;
    projectVersion: string;
    webserverPort: number;
    manufacturer: string;
    friendlyName: string;
    suggestedArea: string;
    bluetoothMacAddress: string;
    apiEncryptionSupported: boolean;
    zwaveProxyFeatureFlags: number;
    /**
     * Check if Z-Wave proxy support is available
     */
    get hasZWaveProxySupport(): boolean;
    serialize(): Bytes;
}
//# sourceMappingURL=DeviceInfoMessages.d.ts.map