import { Bytes, type BytesView } from "@zwave-js/shared";
/**
 * ESPHome message types enum
 */
export declare enum ESPHomeMessageType {
    HelloRequest = 1,
    HelloResponse = 2,
    DisconnectRequest = 5,
    DisconnectResponse = 6,
    PingRequest = 7,
    PingResponse = 8,
    DeviceInfoRequest = 9,
    DeviceInfoResponse = 10,
    ZWaveProxyFrame = 128,
    ZWaveProxyRequest = 129
}
/**
 * Represents a raw ESPHome message with minimal parsing
 */
export declare class ESPHomeMessageRaw {
    readonly messageType: ESPHomeMessageType;
    readonly payload: Bytes;
    constructor(messageType: ESPHomeMessageType, payload: Bytes);
    /**
     * Parses a raw ESPHome frame into a MessageRaw instance
     */
    static parse(data: BytesView): ESPHomeMessageRaw;
}
/**
 * Base interface for ESPHome message options
 */
export interface ESPHomeMessageBaseOptions {
    messageType?: ESPHomeMessageType;
}
/**
 * Interface for message options including payload
 */
export interface ESPHomeMessageOptions extends ESPHomeMessageBaseOptions {
    payload?: Bytes;
}
export type ESPHomeMessageConstructor<T extends ESPHomeMessage> = typeof ESPHomeMessage & {
    new (options: ESPHomeMessageBaseOptions): T;
};
/**
 * Base class for all ESPHome messages
 */
export declare class ESPHomeMessage {
    constructor(options?: ESPHomeMessageOptions);
    messageType: ESPHomeMessageType;
    payload: Bytes;
    /**
     * Parses a raw ESPHome message and returns the appropriate message instance
     */
    static parse(data: BytesView): ESPHomeMessage;
    /**
     * Creates an instance of the message that is serialized in the given raw message
     */
    static from(raw: ESPHomeMessageRaw): ESPHomeMessage;
    /**
     * Serializes this message into an ESPHome frame
     */
    serialize(): Bytes;
}
/**
 * Decorator to set the message type for a message class
 */
export declare function messageType(type: ESPHomeMessageType): (target: any) => any;
//# sourceMappingURL=ESPHomeMessage.d.ts.map