var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { ZWaveError, ZWaveErrorCodes } from "@zwave-js/core";
import { Bytes } from "@zwave-js/shared";
import { ESPHomeMessage, ESPHomeMessageType, messageType, } from "./ESPHomeMessage.js";
import { decodeLengthDelimitedField, encodeStringField, encodeVarintField, parseProtobufMessage, skipField, } from "./ProtobufHelpers.js";
/**
 * ESPHome Z-Wave proxy request types enum
 */
export var ESPHomeZWaveProxyRequestType;
(function (ESPHomeZWaveProxyRequestType) {
    ESPHomeZWaveProxyRequestType[ESPHomeZWaveProxyRequestType["Subscribe"] = 0] = "Subscribe";
    ESPHomeZWaveProxyRequestType[ESPHomeZWaveProxyRequestType["Unsubscribe"] = 1] = "Unsubscribe";
})(ESPHomeZWaveProxyRequestType || (ESPHomeZWaveProxyRequestType = {}));
let ZWaveProxyFrame = (() => {
    let _classDecorators = [messageType(ESPHomeMessageType.ZWaveProxyFrame)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ESPHomeMessage;
    var ZWaveProxyFrame = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ZWaveProxyFrame = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.data = options.data;
        }
        static from(raw) {
            let data = new Bytes();
            parseProtobufMessage(raw.payload, (fieldNumber, wireType, dataBuffer, offset) => {
                switch (fieldNumber) {
                    case 1: // data (bytes as string on wire)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for data", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const dataResult = decodeLengthDelimitedField(dataBuffer, offset);
                        data = Bytes.from(dataResult.value);
                        return offset + dataResult.bytesRead;
                    default:
                        return skipField(dataBuffer, offset, wireType);
                }
            });
            return new this({ data });
        }
        data;
        serialize() {
            const parts = [];
            // Field 1: data (bytes encoded as string field on wire)
            if (this.data.length > 0) {
                parts.push(encodeStringField(1, this.data));
            }
            this.payload = Bytes.concat(parts);
            return super.serialize();
        }
    };
    return ZWaveProxyFrame = _classThis;
})();
export { ZWaveProxyFrame };
let ZWaveProxyRequest = (() => {
    let _classDecorators = [messageType(ESPHomeMessageType.ZWaveProxyRequest)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ESPHomeMessage;
    var ZWaveProxyRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ZWaveProxyRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.type = options.type;
        }
        type;
        serialize() {
            const parts = [];
            // Field 1: request type (varint encoded on wire)
            parts.push(encodeVarintField(1, this.type));
            this.payload = Bytes.concat(parts);
            return super.serialize();
        }
    };
    return ZWaveProxyRequest = _classThis;
})();
export { ZWaveProxyRequest };
//# sourceMappingURL=ZWaveProxyMessages.js.map