import { type RSSI, type UnknownZWaveChipType, ZnifferProtocolDataRate } from "@zwave-js/core";
import { Bytes, type BytesView } from "@zwave-js/shared";
import { ZnifferFrameType, ZnifferFunctionType, ZnifferMessageType } from "./Constants.js";
export type ZnifferMessageConstructor<T extends ZnifferMessage> = typeof ZnifferMessage & {
    new (options: ZnifferMessageOptions): T;
};
export interface ZnifferMessageBaseOptions {
}
export interface ZnifferMessageOptions extends ZnifferMessageBaseOptions {
    type: ZnifferMessageType;
    functionType?: ZnifferFunctionType;
    payload?: Bytes;
}
export declare class ZnifferMessageRaw {
    readonly type: ZnifferMessageType;
    readonly functionType: ZnifferFunctionType | undefined;
    readonly payload: Bytes;
    constructor(type: ZnifferMessageType, functionType: ZnifferFunctionType | undefined, payload: Bytes);
    static parse(data: BytesView): {
        raw: ZnifferMessageRaw;
        bytesRead: number;
    };
    withPayload(payload: Bytes): ZnifferMessageRaw;
}
/**
 * Represents a Zniffer message for communication with the serial interface
 */
export declare class ZnifferMessage {
    constructor(options: ZnifferMessageOptions);
    static parse(data: BytesView): {
        msg: ZnifferMessage;
        bytesRead: number;
    };
    /** Creates an instance of the message that is serialized in the given buffer */
    static from(raw: ZnifferMessageRaw): ZnifferMessage;
    type: ZnifferMessageType;
    functionType?: ZnifferFunctionType;
    payload: Bytes;
    /** Serializes this message into a Buffer */
    serialize(): Bytes;
}
export interface ZnifferFrameInfo {
    readonly frameType: ZnifferFrameType;
    readonly channel: number;
    readonly protocolDataRate: ZnifferProtocolDataRate;
    readonly region: number;
    readonly rssiRaw: number;
    rssi?: RSSI;
}
export interface ZnifferDataMessageOptions {
    frameType: ZnifferFrameType;
    channel: number;
    protocolDataRate: ZnifferProtocolDataRate;
    region: number;
    rssiRaw: number;
    payload: Bytes;
    checksumOK: boolean;
}
export declare class ZnifferDataMessage extends ZnifferMessage implements ZnifferFrameInfo {
    constructor(options: ZnifferDataMessageOptions & ZnifferMessageBaseOptions);
    static from(raw: ZnifferMessageRaw): ZnifferDataMessage;
    readonly frameType: ZnifferFrameType;
    readonly channel: number;
    readonly protocolDataRate: ZnifferProtocolDataRate;
    readonly region: number;
    readonly rssiRaw: number;
    readonly checksumOK: boolean;
}
export declare class ZnifferGetVersionRequest extends ZnifferMessage {
    constructor();
}
export interface ZnifferGetVersionResponseOptions {
    chipType: string | UnknownZWaveChipType;
    majorVersion: number;
    minorVersion: number;
}
export declare class ZnifferGetVersionResponse extends ZnifferMessage {
    constructor(options: ZnifferGetVersionResponseOptions & ZnifferMessageBaseOptions);
    static from(raw: ZnifferMessageRaw): ZnifferGetVersionResponse;
    readonly chipType: string | UnknownZWaveChipType;
    readonly majorVersion: number;
    readonly minorVersion: number;
}
export interface ZnifferSetFrequencyRequestOptions {
    frequency: number;
}
export declare class ZnifferSetFrequencyRequest extends ZnifferMessage {
    constructor(options: ZnifferSetFrequencyRequestOptions);
    frequency: number;
    serialize(): Bytes;
}
export declare class ZnifferSetFrequencyResponse extends ZnifferMessage {
}
export declare class ZnifferGetFrequenciesRequest extends ZnifferMessage {
    constructor();
}
export interface ZnifferGetFrequenciesResponseOptions {
    currentFrequency: number;
    supportedFrequencies: number[];
}
export declare class ZnifferGetFrequenciesResponse extends ZnifferMessage {
    constructor(options: ZnifferGetFrequenciesResponseOptions & ZnifferMessageBaseOptions);
    static from(raw: ZnifferMessageRaw): ZnifferGetFrequenciesResponse;
    readonly currentFrequency: number;
    readonly supportedFrequencies: readonly number[];
}
export declare class ZnifferStartRequest extends ZnifferMessage {
    constructor();
}
export declare class ZnifferStartResponse extends ZnifferMessage {
}
export declare class ZnifferStopRequest extends ZnifferMessage {
    constructor();
}
export declare class ZnifferStopResponse extends ZnifferMessage {
}
export interface ZnifferSetLRChannelConfigRequestOptions {
    channelConfig: number;
}
export declare class ZnifferSetLRChannelConfigRequest extends ZnifferMessage {
    constructor(options: ZnifferSetLRChannelConfigRequestOptions);
    channelConfig: number;
    serialize(): Bytes;
}
export declare class ZnifferSetLRChannelConfigResponse extends ZnifferMessage {
}
export declare class ZnifferGetLRChannelConfigsRequest extends ZnifferMessage {
    constructor();
}
export interface ZnifferGetLRChannelConfigsResponseOptions {
    currentConfig: number;
    supportedConfigs: number[];
}
export declare class ZnifferGetLRChannelConfigsResponse extends ZnifferMessage {
    constructor(options: ZnifferGetLRChannelConfigsResponseOptions & ZnifferMessageBaseOptions);
    static from(raw: ZnifferMessageRaw): ZnifferGetLRChannelConfigsResponse;
    readonly currentConfig: number;
    readonly supportedConfigs: readonly number[];
}
export declare class ZnifferGetLRRegionsRequest extends ZnifferMessage {
    constructor();
}
export interface ZnifferGetLRRegionsResponseOptions {
    regions: number[];
}
export declare class ZnifferGetLRRegionsResponse extends ZnifferMessage {
    constructor(options: ZnifferGetLRRegionsResponseOptions & ZnifferMessageBaseOptions);
    static from(raw: ZnifferMessageRaw): ZnifferGetLRRegionsResponse;
    readonly regions: number[];
}
export interface ZnifferSetBaudRateRequestOptions {
    baudrate: 0;
}
export declare class ZnifferSetBaudRateRequest extends ZnifferMessage {
    constructor(options: ZnifferSetBaudRateRequestOptions);
    baudrate: 0;
    serialize(): Bytes;
}
export declare class ZnifferSetBaudRateResponse extends ZnifferMessage {
}
export interface ZnifferGetFrequencyInfoRequestOptions {
    frequency: number;
}
export declare class ZnifferGetFrequencyInfoRequest extends ZnifferMessage {
    constructor(options: ZnifferGetFrequencyInfoRequestOptions);
    frequency: number;
    serialize(): Bytes;
}
export interface ZnifferGetFrequencyInfoResponseOptions {
    frequency: number;
    numChannels: number;
    frequencyName: string;
}
export declare class ZnifferGetFrequencyInfoResponse extends ZnifferMessage {
    constructor(options: ZnifferGetFrequencyInfoResponseOptions & ZnifferMessageBaseOptions);
    static from(raw: ZnifferMessageRaw): ZnifferGetFrequencyInfoResponse;
    readonly frequency: number;
    readonly numChannels: number;
    readonly frequencyName: string;
}
export interface ZnifferGetLRChannelConfigInfoRequestOptions {
    channelConfig: number;
}
export declare class ZnifferGetLRChannelConfigInfoRequest extends ZnifferMessage {
    constructor(options: ZnifferGetLRChannelConfigInfoRequestOptions);
    channelConfig: number;
    serialize(): Bytes;
}
export interface ZnifferGetLRChannelConfigInfoResponseOptions {
    channelConfig: number;
    numChannels: number;
    configName: string;
}
export declare class ZnifferGetLRChannelConfigInfoResponse extends ZnifferMessage {
    constructor(options: ZnifferGetLRChannelConfigInfoResponseOptions & ZnifferMessageBaseOptions);
    static from(raw: ZnifferMessageRaw): ZnifferGetLRChannelConfigInfoResponse;
    readonly channelConfig: number;
    readonly numChannels: number;
    readonly configName: string;
}
//# sourceMappingURL=ZnifferMessages.d.ts.map