import { BasicDeviceClass, type CommandClasses, type MessageOrCCLogEntry, type NodeUpdatePayload } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes, type BytesView } from "@zwave-js/shared";
export declare enum ApplicationUpdateTypes {
    SmartStart_NodeInfo_Received = 134,// An included smart start node has been powered up
    SmartStart_HomeId_Received = 133,// A smart start node requests inclusion
    SmartStart_LongRange_HomeId_Received = 135,// A smart start long range note requests inclusion
    NodeInfo_Received = 132,
    NodeInfo_RequestDone = 130,
    NodeInfo_RequestFailed = 129,
    RoutingPending = 128,
    Node_Added = 64,// A new node was added to the network by another controller
    Node_Removed = 32,// A new node was removed from the network by another controller
    SUC_IdChanged = 16
}
export interface ApplicationUpdateRequestOptions {
    updateType?: ApplicationUpdateTypes;
}
export declare class ApplicationUpdateRequest extends Message {
    constructor(options?: ApplicationUpdateRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): ApplicationUpdateRequest;
    readonly updateType: ApplicationUpdateTypes;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
export interface ApplicationUpdateRequestWithNodeInfoOptions {
    nodeInformation: NodeUpdatePayload;
}
export declare class ApplicationUpdateRequestWithNodeInfo extends ApplicationUpdateRequest {
    constructor(options: ApplicationUpdateRequestWithNodeInfoOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): ApplicationUpdateRequestWithNodeInfo;
    nodeId: number;
    nodeInformation: NodeUpdatePayload;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
export declare class ApplicationUpdateRequestNodeInfoReceived extends ApplicationUpdateRequestWithNodeInfo {
}
export declare class ApplicationUpdateRequestNodeInfoRequestFailed extends ApplicationUpdateRequest implements SuccessIndicator {
    isOK(): boolean;
}
export declare class ApplicationUpdateRequestNodeAdded extends ApplicationUpdateRequestWithNodeInfo {
}
export interface ApplicationUpdateRequestNodeRemovedOptions {
    nodeId: number;
}
export declare class ApplicationUpdateRequestNodeRemoved extends ApplicationUpdateRequest {
    constructor(options: ApplicationUpdateRequestNodeRemovedOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): ApplicationUpdateRequestNodeRemoved;
    nodeId: number;
}
export interface ApplicationUpdateRequestSmartStartHomeIDReceivedBaseOptions {
    remoteNodeId: number;
    nwiHomeId: BytesView;
    basicDeviceClass: BasicDeviceClass;
    genericDeviceClass: number;
    specificDeviceClass: number;
    supportedCCs: CommandClasses[];
}
declare class ApplicationUpdateRequestSmartStartHomeIDReceivedBase extends ApplicationUpdateRequest {
    constructor(options: ApplicationUpdateRequestSmartStartHomeIDReceivedBaseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): ApplicationUpdateRequestSmartStartHomeIDReceivedBase;
    readonly remoteNodeId: number;
    readonly nwiHomeId: BytesView;
    readonly basicDeviceClass: BasicDeviceClass;
    readonly genericDeviceClass: number;
    readonly specificDeviceClass: number;
    readonly supportedCCs: readonly CommandClasses[];
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ApplicationUpdateRequestSmartStartHomeIDReceived extends ApplicationUpdateRequestSmartStartHomeIDReceivedBase {
}
export declare class ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived extends ApplicationUpdateRequestSmartStartHomeIDReceivedBase {
}
export interface ApplicationUpdateRequestSUCIdChangedOptions {
    sucNodeID: number;
}
export declare class ApplicationUpdateRequestSUCIdChanged extends ApplicationUpdateRequest {
    constructor(options: ApplicationUpdateRequestSUCIdChangedOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): ApplicationUpdateRequestSUCIdChanged;
    sucNodeID: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
//# sourceMappingURL=ApplicationUpdateRequest.d.ts.map