var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, encodeBitMask, parseBitMask } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
const NUM_FUNCTIONS = 256;
const NUM_FUNCTION_BYTES = NUM_FUNCTIONS / 8;
let GetSerialApiCapabilitiesRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.GetSerialApiCapabilities), expectedResponse(FunctionType.GetSerialApiCapabilities), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetSerialApiCapabilitiesRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetSerialApiCapabilitiesRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return GetSerialApiCapabilitiesRequest = _classThis;
})();
export { GetSerialApiCapabilitiesRequest };
let GetSerialApiCapabilitiesResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.GetSerialApiCapabilities)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetSerialApiCapabilitiesResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetSerialApiCapabilitiesResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.firmwareVersion = options.firmwareVersion;
            this.manufacturerId = options.manufacturerId;
            this.productType = options.productType;
            this.productId = options.productId;
            this.supportedFunctionTypes = options.supportedFunctionTypes;
        }
        static from(raw, _ctx) {
            // The first 8 bytes are the api version, manufacturer id, product type and product id
            const firmwareVersion = `${raw.payload[0]}.${raw.payload[1]}`;
            const manufacturerId = raw.payload.readUInt16BE(2);
            const productType = raw.payload.readUInt16BE(4);
            const productId = raw.payload.readUInt16BE(6);
            // then a 256bit bitmask for the supported command classes follows
            const functionBitMask = raw.payload.subarray(8, 8 + NUM_FUNCTION_BYTES);
            const supportedFunctionTypes = parseBitMask(functionBitMask);
            return new this({
                firmwareVersion,
                manufacturerId,
                productType,
                productId,
                supportedFunctionTypes,
            });
        }
        firmwareVersion;
        manufacturerId;
        productType;
        productId;
        supportedFunctionTypes;
        serialize(ctx) {
            this.payload = new Bytes(8 + NUM_FUNCTION_BYTES);
            const firmwareBytes = this.firmwareVersion
                .split(".", 2)
                .map((str) => parseInt(str));
            this.payload[0] = firmwareBytes[0];
            this.payload[1] = firmwareBytes[1];
            this.payload.writeUInt16BE(this.manufacturerId, 2);
            this.payload.writeUInt16BE(this.productType, 4);
            this.payload.writeUInt16BE(this.productId, 6);
            const functionBitMask = encodeBitMask(this.supportedFunctionTypes, NUM_FUNCTIONS);
            this.payload.set(functionBitMask, 8);
            return super.serialize(ctx);
        }
    };
    return GetSerialApiCapabilitiesResponse = _classThis;
})();
export { GetSerialApiCapabilitiesResponse };
//# sourceMappingURL=GetSerialApiCapabilitiesMessages.js.map