import { type CommandClasses, type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export interface SetApplicationNodeInformationRequestOptions extends MessageBaseOptions {
    isListening: boolean;
    genericDeviceClass: number;
    specificDeviceClass: number;
    supportedCCs: CommandClasses[];
    controlledCCs: CommandClasses[];
}
export declare class SetApplicationNodeInformationRequest extends Message {
    constructor(options: SetApplicationNodeInformationRequestOptions);
    isListening: boolean;
    genericDeviceClass: number;
    specificDeviceClass: number;
    supportedCCs: CommandClasses[];
    controlledCCs: CommandClasses[];
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=SetApplicationNodeInformationRequest.d.ts.map