var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, TransmitStatus, encodeNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageOrigin, MessageType, expectedCallback, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName } from "@zwave-js/shared";
let AssignSUCReturnRouteRequestBase = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.AssignSUCReturnRoute), priority(MessagePriority.Normal)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var AssignSUCReturnRouteRequestBase = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            AssignSUCReturnRouteRequestBase = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        static from(raw, ctx) {
            if (ctx.origin === MessageOrigin.Host) {
                return AssignSUCReturnRouteRequest.from(raw, ctx);
            }
            else {
                return AssignSUCReturnRouteRequestTransmitReport.from(raw, ctx);
            }
        }
    };
    return AssignSUCReturnRouteRequestBase = _classThis;
})();
export { AssignSUCReturnRouteRequestBase };
function testAssignSUCReturnRouteCallback(sent, callback) {
    // Some controllers have a bug where they incorrectly respond with DeleteSUCReturnRoute
    if (sent.disableCallbackFunctionTypeCheck) {
        return true;
    }
    return callback.functionType === FunctionType.AssignSUCReturnRoute;
}
let AssignSUCReturnRouteRequest = (() => {
    let _classDecorators = [expectedResponse(FunctionType.AssignSUCReturnRoute), expectedCallback(testAssignSUCReturnRouteCallback)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = AssignSUCReturnRouteRequestBase;
    var AssignSUCReturnRouteRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            AssignSUCReturnRouteRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.nodeId = options.nodeId;
            this.disableCallbackFunctionTypeCheck =
                options.disableCallbackFunctionTypeCheck;
        }
        static from(raw, _ctx) {
            const nodeId = raw.payload[0];
            const callbackId = raw.payload[1];
            return new this({
                nodeId,
                callbackId,
            });
        }
        nodeId;
        disableCallbackFunctionTypeCheck;
        serialize(ctx) {
            this.assertCallbackId();
            const nodeId = encodeNodeID(this.nodeId, ctx.nodeIdType);
            this.payload = Bytes.concat([nodeId, Bytes.from([this.callbackId])]);
            return super.serialize(ctx);
        }
    };
    return AssignSUCReturnRouteRequest = _classThis;
})();
export { AssignSUCReturnRouteRequest };
let AssignSUCReturnRouteResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.AssignSUCReturnRoute)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var AssignSUCReturnRouteResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            AssignSUCReturnRouteResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.wasExecuted = options.wasExecuted;
        }
        static from(raw, _ctx) {
            const wasExecuted = raw.payload[0] !== 0;
            return new this({
                wasExecuted,
            });
        }
        isOK() {
            return this.wasExecuted;
        }
        wasExecuted;
        serialize(ctx) {
            this.payload = Bytes.from([this.wasExecuted ? 0x01 : 0]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { "was executed": this.wasExecuted },
            };
        }
    };
    return AssignSUCReturnRouteResponse = _classThis;
})();
export { AssignSUCReturnRouteResponse };
export class AssignSUCReturnRouteRequestTransmitReport extends AssignSUCReturnRouteRequestBase {
    constructor(options) {
        super(options);
        this.callbackId = options.callbackId;
        this.transmitStatus = options.transmitStatus;
    }
    static from(raw, _ctx) {
        const callbackId = raw.payload[0];
        const transmitStatus = raw.payload[1];
        return new this({
            callbackId,
            transmitStatus,
        });
    }
    isOK() {
        // The other statuses are technically "not OK", but they are caused by
        // not being able to contact the node. We don't want the node to be marked
        // as dead because of that
        return this.transmitStatus !== TransmitStatus.NoAck;
    }
    transmitStatus;
    serialize(ctx) {
        this.assertCallbackId();
        this.payload = Bytes.from([this.callbackId, this.transmitStatus]);
        return super.serialize(ctx);
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId ?? "(not set)",
                "transmit status": getEnumMemberName(TransmitStatus, this.transmitStatus),
            },
        };
    }
}
//# sourceMappingURL=AssignSUCReturnRouteMessages.js.map