var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, NUM_NODEMASK_BYTES, encodeNodeID, parseNodeBitMask, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
let GetRoutingInfoRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.GetRoutingInfo), expectedResponse(FunctionType.GetRoutingInfo), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetRoutingInfoRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetRoutingInfoRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.sourceNodeId = options.nodeId;
            this.removeNonRepeaters = !!options.removeNonRepeaters;
            this.removeBadLinks = !!options.removeBadLinks;
        }
        sourceNodeId;
        removeNonRepeaters;
        removeBadLinks;
        serialize(ctx) {
            const nodeId = encodeNodeID(this.sourceNodeId, ctx.nodeIdType);
            const optionsByte = (this.removeBadLinks ? 0b1000_0000 : 0)
                | (this.removeNonRepeaters ? 0b0100_0000 : 0);
            this.payload = Bytes.concat([
                nodeId,
                Bytes.from([
                    optionsByte,
                    0, // callbackId - this must be 0 as per the docs
                ]),
            ]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    "remove non-repeaters": this.removeNonRepeaters,
                    "remove bad links": this.removeBadLinks,
                },
            };
        }
    };
    return GetRoutingInfoRequest = _classThis;
})();
export { GetRoutingInfoRequest };
let GetRoutingInfoResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.GetRoutingInfo)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetRoutingInfoResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetRoutingInfoResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.nodeIds = options.nodeIds;
        }
        static from(raw, _ctx) {
            let nodeIds;
            if (raw.payload.length === NUM_NODEMASK_BYTES) {
                // the payload contains a bit mask of all neighbor nodes
                nodeIds = parseNodeBitMask(raw.payload);
            }
            else {
                nodeIds = [];
            }
            return new this({
                nodeIds,
            });
        }
        nodeIds;
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { "node ids": `${this.nodeIds.join(", ")}` },
            };
        }
    };
    return GetRoutingInfoResponse = _classThis;
})();
export { GetRoutingInfoResponse };
//# sourceMappingURL=GetRoutingInfoMessages.js.map