var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, TransmitOptions, ZWaveError, ZWaveErrorCodes, encodeNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageOrigin, MessageType, expectedCallback, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export var SetSUCNodeIdStatus;
(function (SetSUCNodeIdStatus) {
    SetSUCNodeIdStatus[SetSUCNodeIdStatus["Succeeded"] = 5] = "Succeeded";
    SetSUCNodeIdStatus[SetSUCNodeIdStatus["Failed"] = 6] = "Failed";
})(SetSUCNodeIdStatus || (SetSUCNodeIdStatus = {}));
let SetSUCNodeIdRequestBase = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.SetSUCNodeId), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SetSUCNodeIdRequestBase = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SetSUCNodeIdRequestBase = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        static from(raw, ctx) {
            if (ctx.origin === MessageOrigin.Host) {
                return SetSUCNodeIdRequest.from(raw, ctx);
            }
            else {
                return SetSUCNodeIdRequestStatusReport.from(raw, ctx);
            }
        }
    };
    return SetSUCNodeIdRequestBase = _classThis;
})();
export { SetSUCNodeIdRequestBase };
let SetSUCNodeIdRequest = (() => {
    let _classDecorators = [expectedResponse(FunctionType.SetSUCNodeId), expectedCallback(FunctionType.SetSUCNodeId)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SetSUCNodeIdRequestBase;
    var SetSUCNodeIdRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SetSUCNodeIdRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.sucNodeId = options.sucNodeId;
            this.enableSUC = options.enableSUC;
            this.enableSIS = options.enableSIS;
            this.transmitOptions = options.transmitOptions
                ?? TransmitOptions.DEFAULT;
            this._ownNodeId = options.ownNodeId;
        }
        static from(_raw, _ctx) {
            throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
            // return new SetSUCNodeIdRequest({});
        }
        sucNodeId;
        enableSUC;
        enableSIS;
        transmitOptions;
        _ownNodeId;
        serialize(ctx) {
            this.assertCallbackId();
            const nodeId = encodeNodeID(this.sucNodeId, ctx.nodeIdType);
            this.payload = Bytes.concat([
                nodeId,
                Bytes.from([
                    this.enableSUC ? 0x01 : 0x00,
                    this.transmitOptions,
                    this.enableSIS ? 0x01 : 0x00,
                    this.callbackId,
                ]),
            ]);
            return super.serialize(ctx);
        }
        expectsCallback() {
            if (this.sucNodeId === this._ownNodeId)
                return false;
            return super.expectsCallback();
        }
    };
    return SetSUCNodeIdRequest = _classThis;
})();
export { SetSUCNodeIdRequest };
let SetSUCNodeIdResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.SetSUCNodeId)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SetSUCNodeIdResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SetSUCNodeIdResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.wasExecuted = options.wasExecuted;
        }
        static from(raw, _ctx) {
            const wasExecuted = raw.payload[0] !== 0;
            return new this({
                wasExecuted,
            });
        }
        isOK() {
            return this.wasExecuted;
        }
        wasExecuted;
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { "was executed": this.wasExecuted },
            };
        }
    };
    return SetSUCNodeIdResponse = _classThis;
})();
export { SetSUCNodeIdResponse };
export class SetSUCNodeIdRequestStatusReport extends SetSUCNodeIdRequestBase {
    constructor(options) {
        super(options);
        // TODO: Check implementation:
        this.callbackId = options.callbackId;
        this.status = options.status;
    }
    static from(raw, _ctx) {
        const callbackId = raw.payload[0];
        const status = raw.payload[1];
        return new this({
            callbackId,
            status,
        });
    }
    status;
    isOK() {
        return this.status === SetSUCNodeIdStatus.Succeeded;
    }
}
//# sourceMappingURL=SetSUCNodeIDMessages.js.map