import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes, type BytesView } from "@zwave-js/shared";
export declare enum ExtendedNVMOperationsCommand {
    Open = 0,
    Read = 1,
    Write = 2,
    Close = 3
}
export declare enum ExtendedNVMOperationStatus {
    OK = 0,
    Error = 1,
    Error_OperationMismatch = 2,
    Error_OperationInterference = 3,
    Error_SubCommandNotSupported = 4,
    EndOfFile = 255
}
export declare class ExtendedNVMOperationsRequest extends Message {
    command: ExtendedNVMOperationsCommand;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ExtendedNVMOperationsOpenRequest extends ExtendedNVMOperationsRequest {
    constructor(options?: MessageBaseOptions);
}
export declare class ExtendedNVMOperationsCloseRequest extends ExtendedNVMOperationsRequest {
    constructor(options?: MessageBaseOptions);
}
export interface ExtendedNVMOperationsReadRequestOptions {
    length: number;
    offset: number;
}
export declare class ExtendedNVMOperationsReadRequest extends ExtendedNVMOperationsRequest {
    constructor(options: ExtendedNVMOperationsReadRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): ExtendedNVMOperationsReadRequest;
    length: number;
    offset: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface ExtendedNVMOperationsWriteRequestOptions {
    offset: number;
    buffer: BytesView;
}
export declare class ExtendedNVMOperationsWriteRequest extends ExtendedNVMOperationsRequest {
    constructor(options: ExtendedNVMOperationsWriteRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): ExtendedNVMOperationsWriteRequest;
    offset: number;
    buffer: BytesView;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface ExtendedNVMOperationsResponseOptions {
    status: ExtendedNVMOperationStatus;
    offsetOrSize: number;
    bufferOrBitmask: BytesView;
}
export declare class ExtendedNVMOperationsResponse extends Message implements SuccessIndicator {
    constructor(options: ExtendedNVMOperationsResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): ExtendedNVMOperationsResponse;
    isOK(): boolean;
    readonly status: ExtendedNVMOperationStatus;
    readonly offsetOrSize: number;
    readonly bufferOrBitmask: BytesView;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=ExtendedNVMOperationsMessages.d.ts.map