var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { getEnumMemberName, num2hex } from "@zwave-js/shared";
export var NVMType;
(function (NVMType) {
    NVMType[NVMType["Flash"] = 128] = "Flash";
    NVMType[NVMType["DataFlash"] = 129] = "DataFlash";
    NVMType[NVMType["EEPROM"] = 255] = "EEPROM";
})(NVMType || (NVMType = {}));
export var NVMSize;
(function (NVMSize) {
    NVMSize[NVMSize["16KB"] = 14] = "16KB";
    NVMSize[NVMSize["32KB"] = 15] = "32KB";
    NVMSize[NVMSize["64KB"] = 16] = "64KB";
    NVMSize[NVMSize["128KB"] = 17] = "128KB";
    NVMSize[NVMSize["256KB"] = 18] = "256KB";
    NVMSize[NVMSize["512KB"] = 19] = "512KB";
    NVMSize[NVMSize["1MB"] = 20] = "1MB";
    NVMSize[NVMSize["2MB"] = 21] = "2MB";
    NVMSize[NVMSize["4MB"] = 22] = "4MB";
    NVMSize[NVMSize["8MB"] = 23] = "8MB";
    NVMSize[NVMSize["16MB"] = 24] = "16MB";
    NVMSize[NVMSize["Unknown"] = 255] = "Unknown";
})(NVMSize || (NVMSize = {}));
export function nvmSizeToBufferSize(size) {
    switch (size) {
        case NVMSize["16KB"]:
            return 16 * 1024;
        case NVMSize["32KB"]:
            return 32 * 1024;
        case NVMSize["64KB"]:
            return 64 * 1024;
        case NVMSize["128KB"]:
            return 128 * 1024;
        case NVMSize["256KB"]:
            return 256 * 1024;
        case NVMSize["512KB"]:
            return 512 * 1024;
        case NVMSize["1MB"]:
            return 1 * 1024 * 1024;
        case NVMSize["2MB"]:
            return 2 * 1024 * 1024;
        case NVMSize["4MB"]:
            return 4 * 1024 * 1024;
        case NVMSize["8MB"]:
            return 8 * 1024 * 1024;
        case NVMSize["16MB"]:
            return 16 * 1024 * 1024;
        default:
            return undefined;
    }
}
let GetNVMIdRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.GetNVMId), expectedResponse(FunctionType.GetNVMId), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetNVMIdRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetNVMIdRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return GetNVMIdRequest = _classThis;
})();
export { GetNVMIdRequest };
let GetNVMIdResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.GetNVMId)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetNVMIdResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetNVMIdResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.nvmManufacturerId = options.nvmManufacturerId;
            this.memoryType = options.memoryType;
            this.memorySize = options.memorySize;
        }
        static from(raw, _ctx) {
            const nvmManufacturerId = raw.payload[1];
            const memoryType = raw.payload[2];
            const memorySize = raw.payload[3];
            return new this({
                nvmManufacturerId,
                memoryType,
                memorySize,
            });
        }
        nvmManufacturerId;
        memoryType;
        memorySize;
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    manufacturer: num2hex(this.nvmManufacturerId),
                    "memory type": getEnumMemberName(NVMType, this.memoryType),
                    "memory size": getEnumMemberName(NVMSize, this.memorySize),
                },
            };
        }
    };
    return GetNVMIdResponse = _classThis;
})();
export { GetNVMIdResponse };
//# sourceMappingURL=GetNVMIdMessages.js.map