import type { CCEncodingContext, CommandClass } from "@zwave-js/cc";
import { type MessageOrCCLogEntry, type MulticastCC, type MulticastDestination, type SerializableTXReport, type SinglecastCC, type TXReport, TransmitOptions, TransmitStatus } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes, type BytesView } from "@zwave-js/shared";
import { type MessageWithCC } from "../utils.js";
export declare const MAX_SEND_ATTEMPTS = 5;
export declare class SendDataRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): SendDataRequestBase;
}
export type SendDataRequestOptions<CCType extends CommandClass = CommandClass> = ({
    command: CCType;
} | {
    nodeId: number;
    serializedCC: BytesView;
}) & {
    transmitOptions?: TransmitOptions;
    maxSendAttempts?: number;
};
export declare class SendDataRequest<CCType extends CommandClass = CommandClass> extends SendDataRequestBase implements MessageWithCC {
    constructor(options: SendDataRequestOptions<CCType> & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): SendDataRequest;
    /** The command this message contains */
    command: SinglecastCC<CCType> | undefined;
    /** Options regarding the transmission of the message */
    transmitOptions: TransmitOptions;
    private _maxSendAttempts;
    /** The number of times the driver may try to send this message */
    get maxSendAttempts(): number;
    set maxSendAttempts(value: number);
    private _nodeId;
    getNodeId(): number | undefined;
    serializedCC: BytesView | undefined;
    serializeCC(ctx: CCEncodingContext): Promise<BytesView>;
    prepareRetransmission(): void;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
    expectsNodeUpdate(): boolean;
    isExpectedNodeUpdate(msg: Message): boolean;
}
export interface SendDataRequestTransmitReportOptions {
    transmitStatus: TransmitStatus;
    txReport?: SerializableTXReport;
}
export declare class SendDataRequestTransmitReport extends SendDataRequestBase implements SuccessIndicator {
    constructor(options: SendDataRequestTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SendDataRequestTransmitReport;
    transmitStatus: TransmitStatus;
    txReport: TXReport | undefined;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    isOK(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SendDataResponseOptions {
    wasSent: boolean;
}
export declare class SendDataResponse extends Message implements SuccessIndicator {
    constructor(options: SendDataResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SendDataResponse;
    wasSent: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    isOK(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SendDataMulticastRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): SendDataMulticastRequestBase;
}
export type SendDataMulticastRequestOptions<CCType extends CommandClass> = ({
    command: CCType;
} | {
    nodeIds: MulticastDestination;
    serializedCC: BytesView;
}) & {
    transmitOptions?: TransmitOptions;
    maxSendAttempts?: number;
};
export declare class SendDataMulticastRequest<CCType extends CommandClass = CommandClass> extends SendDataMulticastRequestBase implements MessageWithCC {
    constructor(options: SendDataMulticastRequestOptions<CCType> & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): SendDataMulticastRequest;
    /** The command this message contains */
    command: MulticastCC<CCType> | undefined;
    /** Options regarding the transmission of the message */
    transmitOptions: TransmitOptions;
    private _maxSendAttempts;
    /** The number of times the driver may try to send this message */
    get maxSendAttempts(): number;
    set maxSendAttempts(value: number);
    nodeIds: MulticastDestination;
    getNodeId(): number | undefined;
    serializedCC: BytesView | undefined;
    serializeCC(ctx: CCEncodingContext): Promise<BytesView>;
    prepareRetransmission(): void;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SendDataMulticastRequestTransmitReportOptions {
    transmitStatus: TransmitStatus;
}
export declare class SendDataMulticastRequestTransmitReport extends SendDataMulticastRequestBase implements SuccessIndicator {
    constructor(options: SendDataMulticastRequestTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SendDataMulticastRequestTransmitReport;
    transmitStatus: TransmitStatus;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    isOK(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SendDataMulticastResponseOptions {
    wasSent: boolean;
}
export declare class SendDataMulticastResponse extends Message implements SuccessIndicator {
    constructor(options: SendDataMulticastResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SendDataMulticastResponse;
    wasSent: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    isOK(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SendDataAbort extends Message {
}
//# sourceMappingURL=SendDataMessages.d.ts.map