import { Powerlevel } from "@zwave-js/cc";
import { type MessageOrCCLogEntry, TransmitStatus } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare class SendTestFrameRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): SendTestFrameRequestBase;
}
export interface SendTestFrameRequestOptions {
    testNodeId: number;
    powerlevel: Powerlevel;
}
export declare class SendTestFrameRequest extends SendTestFrameRequestBase {
    constructor(options: SendTestFrameRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): SendTestFrameRequest;
    testNodeId: number;
    powerlevel: Powerlevel;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SendTestFrameResponseOptions {
    wasSent: boolean;
}
export declare class SendTestFrameResponse extends Message {
    constructor(options: SendTestFrameResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SendTestFrameResponse;
    readonly wasSent: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SendTestFrameTransmitReportOptions {
    transmitStatus: TransmitStatus;
}
export declare class SendTestFrameTransmitReport extends SendTestFrameRequestBase implements SuccessIndicator {
    constructor(options: SendTestFrameTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SendTestFrameTransmitReport;
    transmitStatus: TransmitStatus;
    isOK(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=SendTestFrameMessages.d.ts.map