import { CommandClass } from "@zwave-js/cc";
import { isUint8Array } from "@zwave-js/shared";
import { ApplicationCommandRequest } from "./application/ApplicationCommandRequest.js";
import { BridgeApplicationCommandRequest } from "./application/BridgeApplicationCommandRequest.js";
import { isSendData, } from "./transport/SendDataShared.js";
export function isCommandRequest(msg) {
    return msg instanceof ApplicationCommandRequest
        || msg instanceof BridgeApplicationCommandRequest;
}
export function isMessageWithCC(msg) {
    return isSendData(msg) || isCommandRequest(msg);
}
export function containsSerializedCC(container) {
    return !!container
        && "serializedCC" in container
        && isUint8Array(container.serializedCC);
}
export function containsCC(container) {
    return !!container
        && "command" in container
        && container.command instanceof CommandClass;
}
//# sourceMappingURL=utils.js.map