"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var AsyncQueue_exports = {};
__export(AsyncQueue_exports, {
  AsyncQueue: () => AsyncQueue
});
module.exports = __toCommonJS(AsyncQueue_exports);
var import_deferred_promise = require("alcalzone-shared/deferred-promise");
class AsyncQueue {
  static {
    __name(this, "AsyncQueue");
  }
  /** Adds one or more items onto the queue */
  add(...items) {
    if (items.length === 0 || this.ended)
      return;
    while (items.length > 0 && this.listeners.length > 0) {
      const promise = this.listeners.shift();
      const item = items.shift();
      promise.resolve(item);
    }
    this.backlog.push(...items);
  }
  /**
   * Removes an item from the queue if it was not processed yet.
   * The return value indicates whether the item was removed.
   */
  remove(item) {
    if (this.ended)
      return false;
    const index = this.backlog.indexOf(item);
    if (index !== -1) {
      this.backlog.splice(index, 1);
      return true;
    }
    return false;
  }
  get length() {
    return this.backlog.length;
  }
  // A list of items that have been pushed but not pulled
  backlog = [];
  // A list of Promises that are waiting to be resolved
  listeners = [];
  // Whether the queue was ended
  ended = false;
  /** Ends the queue after it has been drained */
  end() {
    this.ended = true;
  }
  /** Ends the queue and discards all pending items */
  abort() {
    this.ended = true;
    while (this.backlog.length > 0) {
      const removed = this.backlog.pop();
      if (typeof removed === "object" && removed !== null && Symbol.dispose in removed && typeof removed[Symbol.dispose] === "function") {
        console.log("dispose");
        removed[Symbol.dispose]();
      }
    }
    for (const p of this.listeners) {
      p.resolve(void 0);
    }
  }
  [Symbol.asyncIterator]() {
    return {
      next: /* @__PURE__ */ __name(async () => {
        let value;
        if (this.backlog.length > 0) {
          value = this.backlog.shift();
        } else if (!this.ended) {
          const promise = (0, import_deferred_promise.createDeferredPromise)();
          this.listeners.push(promise);
          value = await promise;
        }
        if (value) {
          return { value, done: false };
        } else {
          return { value: void 0, done: true };
        }
      }, "next")
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AsyncQueue
});
//# sourceMappingURL=AsyncQueue.js.map
