"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var TimedExpectation_exports = {};
__export(TimedExpectation_exports, {
  TimedExpectation: () => TimedExpectation
});
module.exports = __toCommonJS(TimedExpectation_exports);
var import_deferred_promise = require("alcalzone-shared/deferred-promise");
var import_Timers = require("./Timers.js");
class TimedExpectation {
  static {
    __name(this, "TimedExpectation");
  }
  constructor(timeoutMs, predicate, timeoutErrorMessage = "Expectation was not fulfilled within the timeout", preventDefault = false) {
    this.promise = (0, import_deferred_promise.createDeferredPromise)();
    this.timeout = (0, import_Timers.setTimer)(() => this.reject(), timeoutMs);
    this.timeoutErrorMessage = timeoutErrorMessage;
    this.predicate = predicate;
    this.preventDefault = preventDefault;
    const tmp = { message: "" };
    Error.captureStackTrace(tmp, TimedExpectation);
    this.stack = tmp.stack.replace(/^Error:?\s*\n/, "");
  }
  promise;
  timeout;
  _done = false;
  timeoutErrorMessage;
  predicate;
  preventDefault;
  /** The stack trace where the timed expectation was created */
  stack;
  resolve(result) {
    if (this._done)
      return;
    this.timeout?.clear();
    this.promise.resolve(result);
  }
  reject() {
    if (this._done)
      return;
    this.timeout?.clear();
    const err = new Error(this.timeoutErrorMessage);
    err.stack = this.stack;
    this.promise.reject(err);
  }
  // Make this await-able
  then(onfulfilled, onrejected) {
    return this.promise.then(onfulfilled, onrejected);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  TimedExpectation
});
//# sourceMappingURL=TimedExpectation.js.map
