"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var inheritance_exports = {};
__export(inheritance_exports, {
  AllOf: () => AllOf,
  Mixin: () => Mixin,
  applyMixin: () => applyMixin,
  staticExtends: () => staticExtends
});
module.exports = __toCommonJS(inheritance_exports);
function Mixin(baseCtors) {
  return function(derivedCtor) {
    for (const baseCtor of baseCtors) {
      applyMixin(derivedCtor, baseCtor);
    }
  };
}
__name(Mixin, "Mixin");
function applyMixin(target, mixin, includeConstructor = false) {
  const inheritanceChain = [mixin];
  while (true) {
    const current = inheritanceChain[0];
    const base = Object.getPrototypeOf(current);
    if (base?.prototype) {
      inheritanceChain.unshift(base);
    } else {
      break;
    }
  }
  for (const ctor of inheritanceChain) {
    for (const prop of Object.getOwnPropertyNames(ctor.prototype)) {
      if (includeConstructor || prop !== "constructor") {
        Object.defineProperty(target.prototype, prop, Object.getOwnPropertyDescriptor(ctor.prototype, prop) ?? /* @__PURE__ */ Object.create(null));
      }
    }
  }
}
__name(applyMixin, "applyMixin");
function AllOf(...BaseClasses) {
  const [First, ...Others] = BaseClasses;
  const ret = class AllOf extends First {
    static {
      __name(this, "AllOf");
    }
  };
  for (const base of Others) {
    applyMixin(ret, base);
  }
  return ret;
}
__name(AllOf, "AllOf");
function staticExtends(constructor, base) {
  while (constructor) {
    if (constructor === base)
      return true;
    constructor = Object.getPrototypeOf(constructor);
  }
  return false;
}
__name(staticExtends, "staticExtends");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AllOf,
  Mixin,
  applyMixin,
  staticExtends
});
//# sourceMappingURL=inheritance.js.map
