"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var strings_exports = {};
__export(strings_exports, {
  buffer2hex: () => buffer2hex,
  compareStrings: () => compareStrings,
  cpp2js: () => cpp2js,
  formatDate: () => formatDate,
  formatId: () => formatId,
  formatTime: () => formatTime,
  isPrintableASCII: () => isPrintableASCII,
  isPrintableASCIIWithWhitespace: () => isPrintableASCIIWithWhitespace,
  num2hex: () => num2hex,
  stringToUint8ArrayUTF16BE: () => stringToUint8ArrayUTF16BE,
  stringify: () => stringify,
  uint8ArrayToStringUTF16BE: () => uint8ArrayToStringUTF16BE
});
module.exports = __toCommonJS(strings_exports);
var import_Bytes = require("./Bytes.js");
var import_uint8array_extras = require("./uint8array-extras.js");
function cpp2js(str) {
  const nullIndex = str.indexOf("\0");
  if (nullIndex === -1)
    return str;
  return str.slice(0, nullIndex);
}
__name(cpp2js, "cpp2js");
function num2hex(val, uppercase = false) {
  if (val == null)
    return "undefined";
  let ret = val.toString(16);
  if (uppercase)
    ret = ret.toUpperCase();
  if (ret.length % 2 !== 0)
    ret = "0" + ret;
  return "0x" + ret;
}
__name(num2hex, "num2hex");
function formatId(id) {
  id = typeof id === "number" ? id.toString(16) : id;
  return "0x" + id.padStart(4, "0").toLowerCase();
}
__name(formatId, "formatId");
function stringify(arg, space = 4) {
  return JSON.stringify(arg, null, space);
}
__name(stringify, "stringify");
function buffer2hex(buffer, uppercase = false) {
  if (buffer.length === 0)
    return "(empty)";
  let ret = (0, import_uint8array_extras.uint8ArrayToHex)(buffer);
  if (uppercase)
    ret = ret.toUpperCase();
  return "0x" + ret;
}
__name(buffer2hex, "buffer2hex");
function isPrintableASCII(text) {
  return /^[\u0020-\u007e]*$/.test(text);
}
__name(isPrintableASCII, "isPrintableASCII");
function isPrintableASCIIWithWhitespace(text) {
  return isPrintableASCII(text.trim());
}
__name(isPrintableASCIIWithWhitespace, "isPrintableASCIIWithWhitespace");
function compareStrings(a, b) {
  if (a > b)
    return 1;
  if (b > a)
    return -1;
  return 0;
}
__name(compareStrings, "compareStrings");
function formatTime(hour, minute) {
  return `${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}`;
}
__name(formatTime, "formatTime");
function formatDate(year, month, day) {
  return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}`;
}
__name(formatDate, "formatDate");
function stringToUint8ArrayUTF16BE(str) {
  const ret = new import_Bytes.Bytes(str.length * 2);
  for (let i = 0; i < str.length; i++) {
    const code = str.charCodeAt(i);
    ret.writeUInt16BE(code, i * 2);
  }
  return ret;
}
__name(stringToUint8ArrayUTF16BE, "stringToUint8ArrayUTF16BE");
function uint8ArrayToStringUTF16BE(arr) {
  let ret = "";
  const view = import_Bytes.Bytes.view(arr);
  for (let i = 0; i < arr.length; i += 2) {
    ret += String.fromCharCode(view.readUInt16BE(i));
  }
  return ret;
}
__name(uint8ArrayToStringUTF16BE, "uint8ArrayToStringUTF16BE");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  buffer2hex,
  compareStrings,
  cpp2js,
  formatDate,
  formatId,
  formatTime,
  isPrintableASCII,
  isPrintableASCIIWithWhitespace,
  num2hex,
  stringToUint8ArrayUTF16BE,
  stringify,
  uint8ArrayToStringUTF16BE
});
//# sourceMappingURL=strings.js.map
