"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var uint8array_extras_exports = {};
__export(uint8array_extras_exports, {
  areUint8ArraysEqual: () => areUint8ArraysEqual,
  assertUint8Array: () => assertUint8Array,
  assertUint8ArrayOrArrayBuffer: () => assertUint8ArrayOrArrayBuffer,
  assertUint8ArrayOrArrayLike: () => assertUint8ArrayOrArrayLike,
  base64ToString: () => base64ToString,
  base64ToUint8Array: () => base64ToUint8Array,
  compareUint8Arrays: () => compareUint8Arrays,
  concatUint8Arrays: () => concatUint8Arrays,
  getUintBE: () => getUintBE,
  hexToUint8Array: () => hexToUint8Array,
  includes: () => includes,
  indexOf: () => indexOf,
  isUint8Array: () => isUint8Array,
  isUint8ArrayOrArrayBuffer: () => isUint8ArrayOrArrayBuffer,
  isUint8ArrayOrArrayLike: () => isUint8ArrayOrArrayLike,
  stringToBase64: () => stringToBase64,
  stringToUint8Array: () => stringToUint8Array,
  toUint8Array: () => toUint8Array,
  uint8ArrayToBase64: () => uint8ArrayToBase64,
  uint8ArrayToHex: () => uint8ArrayToHex,
  uint8ArrayToString: () => uint8ArrayToString
});
module.exports = __toCommonJS(uint8array_extras_exports);
const uint8ArrayStringified = "[object Uint8Array]";
const arrayBufferStringified = "[object ArrayBuffer]";
function isType(value, typeConstructor, typeStringified) {
  if (!value) {
    return false;
  }
  if (value.constructor === typeConstructor) {
    return true;
  }
  return Object.prototype.toString.call(value) === typeStringified;
}
__name(isType, "isType");
function isUint8Array(value) {
  return isType(value, Uint8Array, uint8ArrayStringified) && value.buffer instanceof ArrayBuffer;
}
__name(isUint8Array, "isUint8Array");
function isArrayBuffer(value) {
  return isType(value, ArrayBuffer, arrayBufferStringified);
}
__name(isArrayBuffer, "isArrayBuffer");
function isArrayLike(value) {
  return typeof value === "object" && value !== null && "length" in value && typeof value.length === "number";
}
__name(isArrayLike, "isArrayLike");
function isUint8ArrayOrArrayBuffer(value) {
  return isUint8Array(value) || isArrayBuffer(value);
}
__name(isUint8ArrayOrArrayBuffer, "isUint8ArrayOrArrayBuffer");
function isUint8ArrayOrArrayLike(value) {
  return isUint8Array(value) || isArrayBuffer(value);
}
__name(isUint8ArrayOrArrayLike, "isUint8ArrayOrArrayLike");
function assertUint8Array(value) {
  if (!isUint8Array(value)) {
    throw new TypeError(`Expected \`Uint8Array\`, got \`${typeof value}\``);
  }
}
__name(assertUint8Array, "assertUint8Array");
function assertUint8ArrayOrArrayBuffer(value) {
  if (!isUint8ArrayOrArrayBuffer(value)) {
    throw new TypeError(`Expected \`Uint8Array\` or \`ArrayBuffer\`, got \`${typeof value}\``);
  }
}
__name(assertUint8ArrayOrArrayBuffer, "assertUint8ArrayOrArrayBuffer");
function assertUint8ArrayOrArrayLike(value) {
  if (!isUint8Array(value) && !isArrayLike(value)) {
    throw new TypeError(`Expected \`Uint8Array\` or a numeric array, got \`${typeof value}\``);
  }
}
__name(assertUint8ArrayOrArrayLike, "assertUint8ArrayOrArrayLike");
function toUint8Array(value) {
  if (value instanceof ArrayBuffer) {
    return new Uint8Array(value);
  }
  if (ArrayBuffer.isView(value)) {
    return new Uint8Array(value.buffer, value.byteOffset, value.byteLength);
  }
  throw new TypeError(`Unsupported value, got \`${typeof value}\`.`);
}
__name(toUint8Array, "toUint8Array");
function concatUint8Arrays(arrays, totalLength) {
  if (arrays.length === 0) {
    return new Uint8Array(0);
  }
  totalLength ??= arrays.reduce((accumulator, currentValue) => accumulator + currentValue.length, 0);
  const returnValue = new Uint8Array(totalLength);
  let offset = 0;
  for (let array of arrays) {
    if (isUint8Array(array)) {
      if (offset + array.length > totalLength) {
        array = array.subarray(0, totalLength - offset);
      }
    } else if (isArrayLike(array)) {
      if (offset + array.length > totalLength) {
        array = Uint8Array.from(array).subarray(0, totalLength - offset);
      }
    } else {
      throw new TypeError(`Expected \`Uint8Array\` or a numeric array, got \`${typeof array}\``);
    }
    returnValue.set(array, offset);
    offset += array.length;
    if (offset >= totalLength)
      break;
  }
  return returnValue;
}
__name(concatUint8Arrays, "concatUint8Arrays");
function areUint8ArraysEqual(a, b) {
  assertUint8Array(a);
  assertUint8Array(b);
  if (a === b) {
    return true;
  }
  if (a.length !== b.length) {
    return false;
  }
  for (let index = 0; index < a.length; index++) {
    if (a[index] !== b[index]) {
      return false;
    }
  }
  return true;
}
__name(areUint8ArraysEqual, "areUint8ArraysEqual");
function compareUint8Arrays(a, b) {
  assertUint8Array(a);
  assertUint8Array(b);
  const length = Math.min(a.length, b.length);
  for (let index = 0; index < length; index++) {
    const diff = a[index] - b[index];
    if (diff !== 0) {
      return Math.sign(diff);
    }
  }
  return Math.sign(a.length - b.length);
}
__name(compareUint8Arrays, "compareUint8Arrays");
const cachedDecoders = {
  utf8: new globalThis.TextDecoder("utf8")
};
function uint8ArrayToString(array, encoding = "utf8") {
  assertUint8ArrayOrArrayBuffer(array);
  cachedDecoders[encoding] ??= new globalThis.TextDecoder(encoding);
  return cachedDecoders[encoding].decode(array);
}
__name(uint8ArrayToString, "uint8ArrayToString");
function assertString(value) {
  if (typeof value !== "string") {
    throw new TypeError(`Expected \`string\`, got \`${typeof value}\``);
  }
}
__name(assertString, "assertString");
const cachedEncoder = new globalThis.TextEncoder();
function stringToUint8Array(string) {
  assertString(string);
  return cachedEncoder.encode(string);
}
__name(stringToUint8Array, "stringToUint8Array");
function base64ToBase64Url(base64) {
  return base64.replaceAll("+", "-").replaceAll("/", "_").replace(/=+$/, "");
}
__name(base64ToBase64Url, "base64ToBase64Url");
function base64UrlToBase64(base64url) {
  return base64url.replaceAll("-", "+").replaceAll("_", "/");
}
__name(base64UrlToBase64, "base64UrlToBase64");
const MAX_BLOCK_SIZE = 65535;
function uint8ArrayToBase64(array, options) {
  assertUint8Array(array);
  const { urlSafe = false } = options ?? {};
  let base64;
  if (array.length < MAX_BLOCK_SIZE) {
    base64 = globalThis.btoa(String.fromCodePoint.apply(null, array));
  } else {
    base64 = "";
    for (const value of array) {
      base64 += String.fromCodePoint(value);
    }
    base64 = globalThis.btoa(base64);
  }
  return urlSafe ? base64ToBase64Url(base64) : base64;
}
__name(uint8ArrayToBase64, "uint8ArrayToBase64");
function base64ToUint8Array(base64String) {
  assertString(base64String);
  return Uint8Array.from(globalThis.atob(base64UrlToBase64(base64String)), (x) => x.codePointAt(0));
}
__name(base64ToUint8Array, "base64ToUint8Array");
function stringToBase64(string, options) {
  assertString(string);
  return uint8ArrayToBase64(stringToUint8Array(string), options);
}
__name(stringToBase64, "stringToBase64");
function base64ToString(base64String) {
  assertString(base64String);
  return uint8ArrayToString(base64ToUint8Array(base64String));
}
__name(base64ToString, "base64ToString");
const byteToHexLookupTable = Array.from({ length: 256 }, (_, index) => index.toString(16).padStart(2, "0"));
function uint8ArrayToHex(array) {
  assertUint8Array(array);
  let hexString = "";
  for (let index = 0; index < array.length; index++) {
    hexString += byteToHexLookupTable[array[index]];
  }
  return hexString;
}
__name(uint8ArrayToHex, "uint8ArrayToHex");
const hexToDecimalLookupTable = {
  0: 0,
  1: 1,
  2: 2,
  3: 3,
  4: 4,
  5: 5,
  6: 6,
  7: 7,
  8: 8,
  9: 9,
  a: 10,
  b: 11,
  c: 12,
  d: 13,
  e: 14,
  f: 15,
  A: 10,
  B: 11,
  C: 12,
  D: 13,
  E: 14,
  F: 15
};
function hexToUint8Array(hexString) {
  assertString(hexString);
  if (hexString.length % 2 !== 0) {
    throw new Error("Invalid Hex string length.");
  }
  const resultLength = hexString.length / 2;
  const bytes = new Uint8Array(resultLength);
  for (let index = 0; index < resultLength; index++) {
    const highNibble = hexToDecimalLookupTable[hexString[index * 2]];
    const lowNibble = hexToDecimalLookupTable[hexString[index * 2 + 1]];
    if (highNibble === void 0 || lowNibble === void 0) {
      throw new Error(`Invalid Hex character encountered at position ${index * 2}`);
    }
    bytes[index] = highNibble << 4 | lowNibble;
  }
  return bytes;
}
__name(hexToUint8Array, "hexToUint8Array");
function getUintBE(view) {
  const { byteLength } = view;
  if (byteLength === 6) {
    return view.getUint16(0) * 2 ** 32 + view.getUint32(2);
  }
  if (byteLength === 5) {
    return view.getUint8(0) * 2 ** 32 + view.getUint32(1);
  }
  if (byteLength === 4) {
    return view.getUint32(0);
  }
  if (byteLength === 3) {
    return view.getUint8(0) * 2 ** 16 + view.getUint16(1);
  }
  if (byteLength === 2) {
    return view.getUint16(0);
  }
  if (byteLength === 1) {
    return view.getUint8(0);
  }
  throw new Error("Invalid DataView byteLength.");
}
__name(getUintBE, "getUintBE");
function indexOf(array, value) {
  const arrayLength = array.length;
  const valueLength = value.length;
  if (valueLength === 0) {
    return -1;
  }
  if (valueLength > arrayLength) {
    return -1;
  }
  const validOffsetLength = arrayLength - valueLength;
  for (let index = 0; index <= validOffsetLength; index++) {
    let isMatch = true;
    for (let index2 = 0; index2 < valueLength; index2++) {
      if (array[index + index2] !== value[index2]) {
        isMatch = false;
        break;
      }
    }
    if (isMatch) {
      return index;
    }
  }
  return -1;
}
__name(indexOf, "indexOf");
function includes(array, value) {
  return indexOf(array, value) !== -1;
}
__name(includes, "includes");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  areUint8ArraysEqual,
  assertUint8Array,
  assertUint8ArrayOrArrayBuffer,
  assertUint8ArrayOrArrayLike,
  base64ToString,
  base64ToUint8Array,
  compareUint8Arrays,
  concatUint8Arrays,
  getUintBE,
  hexToUint8Array,
  includes,
  indexOf,
  isUint8Array,
  isUint8ArrayOrArrayBuffer,
  isUint8ArrayOrArrayLike,
  stringToBase64,
  stringToUint8Array,
  toUint8Array,
  uint8ArrayToBase64,
  uint8ArrayToHex,
  uint8ArrayToString
});
//# sourceMappingURL=uint8array-extras.js.map
