import { type CommandClassInfo, type CommandClasses, type NodeProtocolInfoAndDeviceClass } from "@zwave-js/core";
import type { CCIdToCapabilities } from "./CCSpecificCapabilities.js";
export type PartialCCCapabilities<T extends CommandClasses = CommandClasses> = T | ({
    ccId: T;
} & Partial<CommandClassInfo> & Partial<CCIdToCapabilities<T>>);
/** Helper function to infer the correct properties for mock CC capabilities */
export declare function ccCaps<T extends CommandClasses>(caps: PartialCCCapabilities<T>): PartialCCCapabilities<T>;
export interface MockNodeCapabilities extends NodeProtocolInfoAndDeviceClass {
    firmwareVersion: string;
    manufacturerId: number;
    productType: number;
    productId: number;
    /** How long it takes to send a command to or from the node */
    txDelay: number;
}
export interface MockEndpointCapabilities {
    genericDeviceClass: number;
    specificDeviceClass: number;
}
export declare function getDefaultMockNodeCapabilities(): MockNodeCapabilities;
export declare function getDefaultMockEndpointCapabilities(nodeCaps: {
    genericDeviceClass: number;
    specificDeviceClass: number;
}): MockEndpointCapabilities;
//# sourceMappingURL=MockNodeCapabilities.d.ts.map