import { ZWaveLibraryTypes } from "@zwave-js/core";
import { FunctionType } from "@zwave-js/serial";
export function getDefaultSupportedFunctionTypes() {
    return [
        FunctionType.GetSerialApiInitData,
        FunctionType.GetControllerCapabilities,
        FunctionType.SendData,
        FunctionType.SendDataMulticast,
        FunctionType.SendDataBridge,
        FunctionType.SendDataMulticastBridge,
        FunctionType.GetControllerVersion,
        FunctionType.GetControllerId,
        FunctionType.GetNodeProtocolInfo,
        FunctionType.RequestNodeInfo,
        FunctionType.AssignSUCReturnRoute,
        FunctionType.DeleteSUCReturnRoute,
        FunctionType.AddNodeToNetwork,
        FunctionType.RemoveNodeFromNetwork,
    ];
}
export function getDefaultMockControllerCapabilities() {
    return {
        firmwareVersion: "1.0",
        manufacturerId: 0xffff,
        productType: 0xffff,
        productId: 0xfffe,
        supportedFunctionTypes: getDefaultSupportedFunctionTypes(),
        controllerType: ZWaveLibraryTypes["Static Controller"],
        libraryVersion: "Z-Wave 7.17.99",
        zwaveApiVersion: {
            kind: "legacy",
            version: 9,
        },
        isSecondary: false,
        isSISPresent: true,
        isStaticUpdateController: true,
        wasRealPrimary: true,
        isUsingHomeIdFromOtherNetwork: false,
        noNodesIncluded: false,
        sucNodeId: 0,
        supportsTimers: false,
        zwaveChipType: {
            // EFR32ZG14 / ZGM130S
            type: 0x07,
            version: 0x00,
        },
        supportsLongRange: false,
        watchdogEnabled: false,
    };
}
//# sourceMappingURL=MockControllerCapabilities.js.map