import { BasicDeviceClass, NodeType, } from "@zwave-js/core";
/** Helper function to infer the correct properties for mock CC capabilities */
export function ccCaps(caps) {
    return caps;
}
export function getDefaultMockNodeCapabilities() {
    return {
        firmwareVersion: "1.0",
        manufacturerId: 0xffff,
        productType: 0xffff,
        productId: 0xfffe,
        isListening: true,
        isFrequentListening: false,
        isRouting: true,
        supportedDataRates: [9600, 40000, 100000],
        protocolVersion: 3,
        optionalFunctionality: true,
        nodeType: NodeType["End Node"],
        supportsSecurity: false,
        supportsBeaming: true,
        basicDeviceClass: BasicDeviceClass["Routing End Node"],
        genericDeviceClass: 0x06, // Appliance
        specificDeviceClass: 0x01, // General Appliance
        txDelay: 10,
    };
}
export function getDefaultMockEndpointCapabilities(nodeCaps) {
    return {
        genericDeviceClass: nodeCaps.genericDeviceClass,
        specificDeviceClass: nodeCaps.specificDeviceClass,
    };
}
//# sourceMappingURL=MockNodeCapabilities.js.map