import type { SetValueResult } from "@zwave-js/cc";
import type { TranslatedValueID, ValueID } from "@zwave-js/core";
import type { Message } from "@zwave-js/serial";
import type { Driver } from "../driver/Driver.js";
import type { ZWaveController } from "./Controller.js";
import { ControllerProprietary_NabuCasa } from "./proprietary/NabuCasa.js";
export interface ControllerProprietary {
    "Nabu Casa"?: ControllerProprietary_NabuCasa;
}
export declare function getControllerProprietary(driver: Driver, controller: ZWaveController): ControllerProprietary;
export interface ControllerProprietaryCommon {
    interview(): Promise<void>;
    getDefinedValueIDs(): TranslatedValueID[];
    pollValue(valueId: ValueID): Promise<unknown>;
    setValue(valueId: ValueID, value: unknown): Promise<SetValueResult>;
    handleUnsolicited(msg: Message): Promise<boolean>;
}
//# sourceMappingURL=Proprietary.d.ts.map