"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var utils_exports = {};
__export(utils_exports, {
  assertProvisioningEntry: () => assertProvisioningEntry,
  isRebuildRoutesTask: () => isRebuildRoutesTask
});
module.exports = __toCommonJS(utils_exports);
var import_core = require("@zwave-js/core");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_Inclusion = require("./Inclusion.js");
function assertProvisioningEntry(arg) {
  function fail(why) {
    throw new import_core.ZWaveError(`Invalid provisioning entry: ${why}`, import_core.ZWaveErrorCodes.Argument_Invalid);
  }
  __name(fail, "fail");
  if (!(0, import_typeguards.isObject)(arg))
    fail("not an object");
  if (typeof arg.dsk !== "string")
    fail("dsk must be a string");
  else if (!(0, import_core.isValidDSK)(arg.dsk)) {
    fail("dsk does not have the correct format");
  }
  if (arg.status != void 0 && (typeof arg.status !== "number" || !(arg.status in import_Inclusion.ProvisioningEntryStatus))) {
    fail("status is not a ProvisioningEntryStatus");
  }
  if (!(0, import_typeguards.isArray)(arg.securityClasses)) {
    fail("securityClasses must be an array");
  } else if (!arg.securityClasses.every((sc) => typeof sc === "number" && sc in import_core.SecurityClass)) {
    fail("securityClasses contains invalid entries");
  }
  if (arg.requestedSecurityClasses != void 0) {
    if (!(0, import_typeguards.isArray)(arg.requestedSecurityClasses)) {
      fail("requestedSecurityClasses must be an array");
    } else if (!arg.requestedSecurityClasses.every((sc) => typeof sc === "number" && sc in import_core.SecurityClass)) {
      {
        fail("requestedSecurityClasses contains invalid entries");
      }
    }
  }
  if (arg.protocol != void 0 && (typeof arg.protocol !== "number" || !(arg.protocol in import_core.Protocols))) {
    fail("protocol is not a valid");
  }
  if (arg.supportedProtocols != void 0) {
    if (!(0, import_typeguards.isArray)(arg.supportedProtocols)) {
      fail("supportedProtocols must be an array");
    } else if (!arg.supportedProtocols.every((p) => typeof p === "number" && p in import_core.Protocols)) {
      fail("supportedProtocols contains invalid entries");
    }
  }
}
__name(assertProvisioningEntry, "assertProvisioningEntry");
function isRebuildRoutesTask(t) {
  return t.tag?.id === "rebuild-routes" || t.tag?.id === "rebuild-node-routes";
}
__name(isRebuildRoutesTask, "isRebuildRoutesTask");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  assertProvisioningEntry,
  isRebuildRoutesTask
});
//# sourceMappingURL=utils.js.map
