import { type CCEncodingContext } from "@zwave-js/cc";
import type { Message } from "@zwave-js/serial";
import { type ContainsCC, type SendDataMessage } from "@zwave-js/serial/serialapi";
import { type DeferredPromise } from "alcalzone-shared/deferred-promise";
import type { Driver } from "./Driver.js";
import type { MessageGenerator } from "./Transaction.js";
export type MessageGeneratorImplementation<T extends Message> = (
/** A reference to the driver */
driver: Driver, ctx: CCEncodingContext, 
/** The "primary" message */
message: T, 
/**
 * A hook to get notified about each sent message and the result of the Serial API call
 * without waiting for the message generator to finish completely.
 */
onMessageSent: (msg: Message, result: Message | undefined) => void, 
/** Can be used to extend the timeout waiting for a response from a node to the sent message */
additionalCommandTimeoutMs?: number) => AsyncGenerator<Message, Message, Message>;
export declare function waitForNodeUpdate<T extends Message>(driver: Driver, msg: Message, timeoutMs: number): Promise<T>;
/** A simple message generator that simply sends a message, waits for the ACK (and the response if one is expected) */
export declare const simpleMessageGenerator: MessageGeneratorImplementation<Message>;
/** A generator for singlecast SendData messages that automatically uses Transport Service when necessary */
export declare const maybeTransportServiceGenerator: MessageGeneratorImplementation<SendDataMessage & ContainsCC>;
/** A message generator for security encapsulated messages (S0) */
export declare const secureMessageGeneratorS0: MessageGeneratorImplementation<SendDataMessage & ContainsCC>;
/** A message generator for security encapsulated messages (S2) */
export declare const secureMessageGeneratorS2: MessageGeneratorImplementation<SendDataMessage & ContainsCC>;
/** A message generator for security encapsulated messages (S2 Multicast) */
export declare const secureMessageGeneratorS2Multicast: MessageGeneratorImplementation<SendDataMessage & ContainsCC>;
export declare function createMessageGenerator<TResponse extends Message = Message>(driver: Driver, ctx: CCEncodingContext, msg: Message, onMessageSent: (msg: Message, result: Message | undefined) => void): {
    generator: MessageGenerator;
    resultPromise: DeferredPromise<TResponse>;
};
//# sourceMappingURL=MessageGenerators.d.ts.map