"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var StateMachineShared_exports = {};
__export(StateMachineShared_exports, {
  createMessageDroppedUnexpectedError: () => createMessageDroppedUnexpectedError,
  serialAPICommandErrorToZWaveError: () => serialAPICommandErrorToZWaveError
});
module.exports = __toCommonJS(StateMachineShared_exports);
var import_core = require("@zwave-js/core");
var import_serialapi = require("@zwave-js/serial/serialapi");
var import_shared = require("@zwave-js/shared");
function serialAPICommandErrorToZWaveError(reason, sentMessage, receivedMessage, transactionSource) {
  switch (reason) {
    case "CAN":
    case "NAK":
      return new import_core.ZWaveError(`Failed to execute controller command`, import_core.ZWaveErrorCodes.Controller_MessageDropped, reason, transactionSource);
    case "ACK timeout":
      return new import_core.ZWaveError(`Timeout while waiting for an ACK from the controller`, import_core.ZWaveErrorCodes.Controller_Timeout, "ACK", transactionSource);
    case "response timeout":
      return new import_core.ZWaveError(`Timeout while waiting for a response from the controller`, import_core.ZWaveErrorCodes.Controller_Timeout, "response", transactionSource);
    case "callback timeout":
      return new import_core.ZWaveError(`Timeout while waiting for a callback from the controller`, import_core.ZWaveErrorCodes.Controller_Timeout, "callback", transactionSource);
    case "response NOK": {
      if ((0, import_serialapi.isSendData)(sentMessage)) {
        return new import_core.ZWaveError(`Failed to send the command: Transmission queue full`, import_core.ZWaveErrorCodes.Controller_MessageDropped, receivedMessage, transactionSource);
      } else {
        return new import_core.ZWaveError(`The controller response indicated failure`, import_core.ZWaveErrorCodes.Controller_ResponseNOK, receivedMessage, transactionSource);
      }
    }
    case "callback NOK": {
      if ((0, import_serialapi.isSendData)(sentMessage) && (0, import_serialapi.isSendDataTransmitReport)(receivedMessage) && receivedMessage.transmitStatus === import_core.TransmitStatus.Fail) {
        return new import_core.ZWaveError(`Failed to send the command, the controller is jammed`, import_core.ZWaveErrorCodes.Controller_Jammed, receivedMessage, transactionSource);
      }
      if (sentMessage instanceof import_serialapi.SendDataRequest || sentMessage instanceof import_serialapi.SendDataBridgeRequest) {
        const status = receivedMessage.transmitStatus;
        return new import_core.ZWaveError(`Failed to send the command (Status ${(0, import_shared.getEnumMemberName)(import_core.TransmitStatus, status)})`, status === import_core.TransmitStatus.NoAck ? import_core.ZWaveErrorCodes.Controller_CallbackNOK : import_core.ZWaveErrorCodes.Controller_MessageDropped, receivedMessage, transactionSource);
      } else if (sentMessage instanceof import_serialapi.SendDataMulticastRequest || sentMessage instanceof import_serialapi.SendDataMulticastBridgeRequest) {
        const status = receivedMessage.transmitStatus;
        return new import_core.ZWaveError(`One or more nodes did not respond to the multicast request (Status ${(0, import_shared.getEnumMemberName)(import_core.TransmitStatus, status)})`, status === import_core.TransmitStatus.NoAck ? import_core.ZWaveErrorCodes.Controller_CallbackNOK : import_core.ZWaveErrorCodes.Controller_MessageDropped, receivedMessage, transactionSource);
      } else {
        return new import_core.ZWaveError(`The controller callback indicated failure`, import_core.ZWaveErrorCodes.Controller_CallbackNOK, receivedMessage, transactionSource);
      }
    }
  }
}
__name(serialAPICommandErrorToZWaveError, "serialAPICommandErrorToZWaveError");
function createMessageDroppedUnexpectedError(original) {
  const ret = new import_core.ZWaveError(`Message dropped because of an unexpected error: ${original.message}`, import_core.ZWaveErrorCodes.Controller_MessageDropped);
  if (original.stack)
    ret.stack = original.stack;
  return ret;
}
__name(createMessageDroppedUnexpectedError, "createMessageDroppedUnexpectedError");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createMessageDroppedUnexpectedError,
  serialAPICommandErrorToZWaveError
});
//# sourceMappingURL=StateMachineShared.js.map
