"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Transaction_exports = {};
__export(Transaction_exports, {
  Transaction: () => Transaction
});
module.exports = __toCommonJS(Transaction_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_comparable = require("alcalzone-shared/comparable");
var import_Types = require("../node/_Types.js");
class Transaction {
  static {
    __name(this, "Transaction");
  }
  driver;
  options;
  constructor(driver, options) {
    this.driver = driver;
    this.options = options;
    options.parts.parent = this;
    this.promise = options.promise;
    this.message = options.message;
    this.priority = options.priority;
    this.parts = options.parts;
    this.listener = options.listener;
    const tmp = { message: "" };
    Error.captureStackTrace(tmp, Transaction);
    this._stack = tmp.stack.replace(/^Error:?\s*\n/, "");
  }
  clone() {
    const ret = new Transaction(this.driver, this.options);
    for (const prop of [
      "_stack",
      "_progress",
      "creationTimestamp",
      "changeNodeStatusOnTimeout",
      "pauseSendThread",
      "priority",
      "tag",
      "requestWakeUpOnDemand"
    ]) {
      ret[prop] = this[prop];
    }
    this.listener = void 0;
    return ret;
  }
  /** Will be resolved/rejected by the Send Thread Machine when the entire transaction is handled */
  promise;
  /** The "primary" message this transaction contains, e.g. the un-encapsulated version of a SendData request */
  message;
  /** The message generator to create the actual messages for this transaction */
  parts;
  /** A callback which gets called with state updates of this transaction */
  listener;
  _progress;
  setProgress(progress) {
    if (this._progress?.state === progress.state)
      return;
    this._progress = progress;
    this.listener?.({ ...progress });
  }
  /**
   * Returns the current message of this transaction. This is either the currently active partial message
   * or the primary message if the generator hasn't been started yet.
   */
  getCurrentMessage() {
    return this.parts.current ?? this.message;
  }
  /**
   * Starts the transaction's message generator if it hasn't been started yet.
   * Returns `true` when the generator was started, `false` if it was already started before.
   */
  start() {
    if (!this.parts.self) {
      this.parts.start();
      return true;
    }
    return false;
  }
  /**
   * Resets this transaction's message generator
   */
  reset() {
    this.parts.reset();
  }
  async generateNextMessage(prevResult) {
    if (!this.parts.self)
      return;
    const { done, value } = await this.parts.self.next(prevResult);
    if (!done)
      return value;
  }
  /**
   * Forcefully aborts the message generator by throwing the given result.
   * Errors will be treated as a rejection of the transaction, everything else as success
   */
  abort(result) {
    if (this.parts.self) {
      this.parts.self.throw(result).catch(import_shared.noop);
    } else if ((0, import_core.isZWaveError)(result)) {
      this.promise.reject(result);
    } else {
      this.promise.resolve(result);
    }
  }
  /** The priority of this transaction */
  priority;
  /** The timestamp at which the transaction was created */
  creationTimestamp = (0, import_core.highResTimestamp)();
  /** Whether the node status should be updated when this transaction times out */
  changeNodeStatusOnTimeout = true;
  /** Whether the send thread MUST be paused after this transaction was handled */
  pauseSendThread = false;
  /** If a Wake Up On Demand should be requested for the target node. */
  requestWakeUpOnDemand = false;
  /** Internal information used to identify or mark this transaction */
  tag;
  /** The stack trace where the transaction was created */
  _stack;
  get stack() {
    return this._stack;
  }
  /** Compares two transactions in order to plan their transmission sequence */
  compareTo(other) {
    const compareWakeUpPriority = /* @__PURE__ */ __name((_this, _other) => {
      const thisNode = _this.message.tryGetNode(this.driver);
      const otherNode = _other.message.tryGetNode(this.driver);
      const thisIsAsleep = thisNode?.status === import_Types.NodeStatus.Asleep;
      const otherIsAsleep = otherNode?.status === import_Types.NodeStatus.Asleep;
      if (thisIsAsleep && !otherIsAsleep)
        return 1;
      if (otherIsAsleep && !thisIsAsleep)
        return -1;
    }, "compareWakeUpPriority");
    if (this.priority === import_core.MessagePriority.WakeUp) {
      const result = compareWakeUpPriority(this, other);
      if (result != void 0)
        return result;
    } else if (other.priority === import_core.MessagePriority.WakeUp) {
      const result = compareWakeUpPriority(other, this);
      if (result != void 0)
        return -result;
    }
    const compareNodeQueryPriority = /* @__PURE__ */ __name((_this, _other) => {
      const thisNode = _this.message.tryGetNode(this.driver);
      const otherNode = _other.message.tryGetNode(this.driver);
      if (thisNode && otherNode) {
        const thisListening = thisNode.isListening || thisNode.isFrequentListening;
        const otherListening = otherNode.isListening || otherNode.isFrequentListening;
        if (thisListening && !otherListening)
          return -1;
        if (!thisListening && otherListening)
          return 1;
      }
    }, "compareNodeQueryPriority");
    if (this.priority === import_core.MessagePriority.NodeQuery) {
      const result = compareNodeQueryPriority(this, other);
      if (result != void 0)
        return result;
    } else if (other.priority === import_core.MessagePriority.NodeQuery) {
      const result = compareNodeQueryPriority(other, this);
      if (result != void 0)
        return -result;
    }
    if (this.priority < other.priority)
      return -1;
    else if (this.priority > other.priority)
      return 1;
    return (0, import_comparable.compareNumberOrString)(other.creationTimestamp, this.creationTimestamp);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Transaction
});
//# sourceMappingURL=Transaction.js.map
