"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EntryControlCC_exports = {};
__export(EntryControlCC_exports, {
  getDefaultEntryControlHandlerStore: () => getDefaultEntryControlHandlerStore,
  handleEntryControlNotification: () => handleEntryControlNotification
});
module.exports = __toCommonJS(EntryControlCC_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
function getDefaultEntryControlHandlerStore() {
  return {
    recentSequenceNumbers: []
  };
}
__name(getDefaultEntryControlHandlerStore, "getDefaultEntryControlHandlerStore");
function handleEntryControlNotification(ctx, node, command, store) {
  if (!node.deviceConfig?.compat?.disableStrictEntryControlDataValidation) {
    if (store.recentSequenceNumbers.includes(command.sequenceNumber)) {
      ctx.logNode(node.id, `Received duplicate Entry Control Notification (sequence number ${command.sequenceNumber}), ignoring...`, "warn");
      return;
    }
    store.recentSequenceNumbers.unshift(command.sequenceNumber);
    if (store.recentSequenceNumbers.length > 5) {
      store.recentSequenceNumbers.pop();
    }
  }
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  node.emit("notification", endpoint, import_core.CommandClasses["Entry Control"], {
    ...(0, import_shared.pick)(command, ["eventType", "dataType", "eventData"]),
    eventTypeLabel: import_cc.entryControlEventTypeLabels[command.eventType],
    dataTypeLabel: (0, import_shared.getEnumMemberName)(import_cc.EntryControlDataTypes, command.dataType)
  });
}
__name(handleEntryControlNotification, "handleEntryControlNotification");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getDefaultEntryControlHandlerStore,
  handleEntryControlNotification
});
//# sourceMappingURL=EntryControlCC.js.map
