"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var HailCC_exports = {};
__export(HailCC_exports, {
  getDefaultHailHandlerStore: () => getDefaultHailHandlerStore,
  handleHail: () => handleHail
});
module.exports = __toCommonJS(HailCC_exports);
function getDefaultHailHandlerStore() {
  return {
    busyPolling: false
  };
}
__name(getDefaultHailHandlerStore, "getDefaultHailHandlerStore");
async function handleHail(ctx, node, _command, store) {
  node.markAsAwake();
  if (store.busyPolling) {
    ctx.logNode(node.id, {
      message: `Hail received from node, but still busy with previous one...`
    });
    return;
  }
  ctx.logNode(node.id, {
    message: `Hail received from node, refreshing actuator and sensor values...`
  });
  try {
    store.busyPolling = true;
    await node.refreshValues();
  } catch {
  } finally {
    store.busyPolling = false;
  }
}
__name(handleHail, "handleHail");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getDefaultHailHandlerStore,
  handleHail
});
//# sourceMappingURL=HailCC.js.map
