"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var IndicatorCC_exports = {};
__export(IndicatorCC_exports, {
  handleIndicatorDescriptionGet: () => handleIndicatorDescriptionGet,
  handleIndicatorGet: () => handleIndicatorGet,
  handleIndicatorSet: () => handleIndicatorSet,
  handleIndicatorSupportedGet: () => handleIndicatorSupportedGet
});
module.exports = __toCommonJS(IndicatorCC_exports);
var import_core = require("@zwave-js/core");
function handleIndicatorSupportedGet(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Indicator, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  switch (command.indicatorId) {
    case 0:
    // 0 must be answered with the first supported indicator ID.
    // We only support identify (0x50)
    case 80:
      return api.reportSupported(80, [3, 4, 5], 0);
    default:
      return api.reportSupported(0, [], 0);
  }
}
__name(handleIndicatorSupportedGet, "handleIndicatorSupportedGet");
function handleIndicatorSet(ctx, controller, node, command) {
  if (command.values?.length !== 3)
    return;
  const [v1, v2, v3] = command.values;
  if (v1.indicatorId !== 80 || v1.propertyId !== 3)
    return;
  if (v2.indicatorId !== 80 || v2.propertyId !== 4)
    return;
  if (v3.indicatorId !== 80 || v3.propertyId !== 5)
    return;
  const store = controller.indicatorValues;
  store.set(80, [v1, v2, v3]);
  ctx.logNode(node.id, {
    message: "Received identify command",
    direction: "inbound"
  });
  controller.emit("identify", node);
}
__name(handleIndicatorSet, "handleIndicatorSet");
async function handleIndicatorGet(ctx, controller, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Indicator, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  if (command.indicatorId === 80) {
    const values = controller.indicatorValues.get(80) ?? [
      { indicatorId: 80, propertyId: 3, value: 0 },
      { indicatorId: 80, propertyId: 4, value: 0 },
      { indicatorId: 80, propertyId: 5, value: 0 }
    ];
    await api.sendReport({ values });
  } else if (typeof command.indicatorId === "number") {
    await api.sendReport({
      values: [
        {
          indicatorId: command.indicatorId,
          propertyId: 0,
          value: 0
        }
      ]
    });
  } else {
    await api.sendReport({ value: 0 });
  }
}
__name(handleIndicatorGet, "handleIndicatorGet");
async function handleIndicatorDescriptionGet(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Indicator, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  await api.reportDescription(command.indicatorId, "");
}
__name(handleIndicatorDescriptionGet, "handleIndicatorDescriptionGet");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleIndicatorDescriptionGet,
  handleIndicatorGet,
  handleIndicatorSet,
  handleIndicatorSupportedGet
});
//# sourceMappingURL=IndicatorCC.js.map
