"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var TimeCC_exports = {};
__export(TimeCC_exports, {
  handleDateGet: () => handleDateGet,
  handleTimeGet: () => handleTimeGet,
  handleTimeOffsetGet: () => handleTimeOffsetGet
});
module.exports = __toCommonJS(TimeCC_exports);
var import_core = require("@zwave-js/core");
async function handleTimeGet(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const now = /* @__PURE__ */ new Date();
  const hours = now.getHours();
  const minutes = now.getMinutes();
  const seconds = now.getSeconds();
  try {
    const api = endpoint.createAPI(import_core.CommandClasses.Time, false).withOptions({
      // Answer with the same encapsulation as asked, but omit
      // Supervision as it shouldn't be used for Get-Report flows
      encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
    });
    await api.reportTime(hours, minutes, seconds);
  } catch (e) {
    ctx.logNode(node.id, {
      message: e.message,
      level: "error"
    });
  }
}
__name(handleTimeGet, "handleTimeGet");
async function handleDateGet(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const now = /* @__PURE__ */ new Date();
  const year = now.getFullYear();
  const month = now.getMonth() + 1;
  const day = now.getDate();
  try {
    const api = endpoint.createAPI(import_core.CommandClasses.Time, false).withOptions({
      // Answer with the same encapsulation as asked, but omit
      // Supervision as it shouldn't be used for Get-Report flows
      encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
    });
    await api.reportDate(year, month, day);
  } catch (e) {
    ctx.logNode(node.id, {
      message: e.message,
      level: "error"
    });
  }
}
__name(handleDateGet, "handleDateGet");
async function handleTimeOffsetGet(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const timezone = (0, import_core.getDSTInfo)(/* @__PURE__ */ new Date());
  try {
    const api = endpoint.createAPI(import_core.CommandClasses.Time, false).withOptions({
      // Answer with the same encapsulation as asked, but omit
      // Supervision as it shouldn't be used for Get-Report flows
      encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
    });
    await api.reportTimezone(timezone);
  } catch {
  }
}
__name(handleTimeOffsetGet, "handleTimeOffsetGet");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleDateGet,
  handleTimeGet,
  handleTimeOffsetGet
});
//# sourceMappingURL=TimeCC.js.map
